/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.sound;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3419;

public class SoundHandler {
    private static Map<String, Clip> sounds = new HashMap<String, Clip>();
    private static boolean init = false;

    public static void init() {
        if (!init) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    float lastMaster = 0.0f;
                    while (true) {
                        try {
                            while (true) {
                                class_315 o;
                                if ((o = class_310.method_1551().field_1690) != null) {
                                    float currentMaster = o.method_1630(class_3419.field_15250);
                                    if (lastMaster != currentMaster) {
                                        SoundHandler.updateVolume();
                                    }
                                    lastMaster = currentMaster;
                                }
                                Thread.sleep(100L);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            }).start();
            init = true;
        }
    }

    public static void registerSound(String key, String path) {
        if (!sounds.containsKey(key)) {
            try {
                Clip c = AudioSystem.getClip();
                BufferedInputStream s = new BufferedInputStream(new FileInputStream(new File(path)));
                AudioInputStream inputStream = AudioSystem.getAudioInputStream(s);
                c.open(inputStream);
                sounds.put(key, c);
                if (class_310.method_1551().field_1690 != null) {
                    SoundHandler.setVolume(key, SoundHandler.getMinecraftMasterVolume());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void unregisterSound(String key) {
        if (sounds.containsKey(key)) {
            sounds.get(key).stop();
            sounds.get(key).close();
            sounds.remove(key);
        }
    }

    public static void playSound(String key) {
        if (sounds.containsKey(key)) {
            sounds.get(key).start();
        }
    }

    public static void stopSound(String key) {
        if (sounds.containsKey(key)) {
            sounds.get(key).stop();
        }
    }

    public static void resetSound(String key) {
        if (sounds.containsKey(key)) {
            sounds.get(key).setMicrosecondPosition(0L);
        }
    }

    public static boolean soundExists(String key) {
        return sounds.containsKey(key);
    }

    public static void setLooped(String key, boolean looped) {
        if (sounds.containsKey(key)) {
            Clip c = sounds.get(key);
            if (looped) {
                c.setLoopPoints(0, -1);
                c.loop(-1);
            } else {
                c.loop(0);
            }
        }
    }

    public static boolean isPlaying(String key) {
        return sounds.containsKey(key) && sounds.get(key).isRunning();
    }

    public static void updateVolume() {
        for (String s : sounds.keySet()) {
            SoundHandler.setVolume(s, SoundHandler.getMinecraftMasterVolume());
        }
    }

    private static void setVolume(String key, int percentage) {
        FloatControl f = (FloatControl)sounds.get(key).getControl(FloatControl.Type.MASTER_GAIN);
        int gain = (int)((float)((int)f.getMinimum()) + (f.getMaximum() - f.getMinimum()) / 100.0f * (float)percentage);
        f.setValue(gain);
    }

    private static int getMinecraftMasterVolume() {
        float vol = class_310.method_1551().field_1690.method_1630(class_3419.field_15250);
        int volPercent = (int)(vol * 100.0f);
        return volPercent;
    }
}

