/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.locallooks;

import com.github.alexthe666.locallooks.ClientProxy;
import com.github.alexthe666.locallooks.CommonProxy;
import com.github.alexthe666.locallooks.MagicMirrorItem;
import com.github.alexthe666.locallooks.config.ConfigHolder;
import com.github.alexthe666.locallooks.message.CloseMirrorMessage;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="locallooks")
@Mod.EventBusSubscriber(modid="locallooks", bus=Mod.EventBusSubscriber.Bus.MOD)
public class LocalLooks {
    public static final String MODID = "locallooks";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Item MAGIC_MIRROR = new MagicMirrorItem();
    public static CommonProxy PROXY = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    private static int packetsRegistered;
    public static final SimpleChannel NETWORK_WRAPPER;
    public static SoundEvent MIRROR_SOUND;

    public LocalLooks() {
        PROXY.init();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupClient);
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        modLoadingContext.registerConfig(ModConfig.Type.COMMON, ConfigHolder.SERVER_SPEC);
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, ConfigHolder.CLIENT_SPEC);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setupClient(FMLClientSetupEvent event) {
        PROXY.clientInit();
    }

    @SubscribeEvent
    public static void registerItem(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)MAGIC_MIRROR);
    }

    @SubscribeEvent
    public static void registerSound(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().register((IForgeRegistryEntry)MIRROR_SOUND);
    }

    public static <MSG> void sendMSGToServer(MSG message) {
        NETWORK_WRAPPER.sendToServer(message);
    }

    public static <MSG> void sendMSGToAll(MSG message) {
        for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
            LocalLooks.sendNonLocal(message, player);
        }
    }

    public static <MSG> void sendNonLocal(MSG msg, ServerPlayerEntity player) {
        if (player.field_71133_b.func_71262_S() || !player.func_200200_C_().equals(player.field_71133_b.func_71214_G())) {
            NETWORK_WRAPPER.sendTo(msg, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        NETWORK_WRAPPER.registerMessage(packetsRegistered++, CloseMirrorMessage.class, CloseMirrorMessage::write, CloseMirrorMessage::read, CloseMirrorMessage.Handler::handle);
    }

    static {
        MIRROR_SOUND = (SoundEvent)new SoundEvent(new ResourceLocation("locallooks:magic_mirror")).setRegistryName("locallooks:magic_mirror");
        NetworkRegistry.ChannelBuilder channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(MODID, "main_channel"));
        String version = PROTOCOL_VERSION;
        version.getClass();
        channel = channel.clientAcceptedVersions(version::equals);
        version = PROTOCOL_VERSION;
        version.getClass();
        NETWORK_WRAPPER = channel.serverAcceptedVersions(version::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    }
}

