/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.locallooks.client.screen;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import com.github.alexthe666.citadel.server.message.PropertiesMessage;
import com.github.alexthe666.locallooks.LocalLooks;
import com.github.alexthe666.locallooks.config.ConfigHolder;
import com.github.alexthe666.locallooks.message.CloseMirrorMessage;
import com.github.alexthe666.locallooks.skin.SkinLoader;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class LookCustomizationScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("locallooks:textures/gui/mirror.png");
    private static final ResourceLocation TEXTURE_SHEEN = new ResourceLocation("locallooks:textures/gui/mirror_sheen.png");
    private static final ITextComponent TITLE_TEXT = new TranslationTextComponent("gui.locallooks.mirror_title");
    private static final ITextComponent ENTER_URL_TEXT = new TranslationTextComponent("gui.locallooks.enter_url");
    private int sizePx = 250;
    private TextFieldWidget skinURLField;
    private String enteredURL = "";
    private float mousePosX;
    private float mousePosY;
    private int loadingWarning = 0;
    private Button refreshURLBtn;
    private boolean smallArms = false;
    private float transProgress = 0.0f;
    private float prevTransProgress = 0.0f;
    private boolean offhand;
    private boolean consumeMirror;

    public LookCustomizationScreen(boolean offhand) {
        super(TITLE_TEXT);
        this.offhand = offhand;
    }

    private boolean isCreative() {
        return Minecraft.func_71410_x().field_71439_g.func_184812_l_() || Minecraft.func_71410_x().field_71439_g.func_175149_v();
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.prevTransProgress = this.transProgress;
        this.skinURLField.func_146178_a();
        if (this.transProgress > 0.0f) {
            this.transProgress -= 0.5f;
        }
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        int i = (this.field_230708_k_ - this.sizePx) / 2;
        int j = (this.field_230709_l_ - this.sizePx) / 2;
        this.refreshURLBtn = new Button(i + 128, j + 75, 80, 20, (ITextComponent)new TranslationTextComponent("gui.locallooks.refresh"), p_214132_1_ -> {
            this.enteredURL = this.skinURLField.func_146179_b();
            this.loadingWarning = SkinLoader.testURL(this.enteredURL);
            this.changePlayerTexture(false, true, false);
        });
        this.func_230480_a_((Widget)this.refreshURLBtn);
        this.refreshURLBtn.field_230693_o_ = false;
        this.skinURLField = new TextFieldWidget(this.field_230712_o_, i + 130, j + 50, 180, 20, (ITextComponent)new TranslationTextComponent("selectWorld.enterName")){

            protected IFormattableTextComponent func_230442_c_() {
                return super.func_230442_c_().func_240702_b_(". ").func_230529_a_(ENTER_URL_TEXT).func_240702_b_(" ").func_240702_b_(LookCustomizationScreen.this.enteredURL);
            }
        };
        this.skinURLField.func_146203_f(50000);
        this.skinURLField.func_146180_a(this.enteredURL);
        this.skinURLField.func_212954_a(p_214319_1_ -> {
            this.enteredURL = p_214319_1_;
            this.refreshURLBtn.field_230693_o_ = !this.skinURLField.func_146179_b().isEmpty();
        });
        this.field_230705_e_.add(this.skinURLField);
        this.func_230480_a_((Widget)new Button(i + 150, j + 160, 140, 20, (ITextComponent)new TranslationTextComponent("gui.locallooks.toggle_arms"), p_214132_1_ -> {
            this.smallArms = !this.smallArms;
            this.changePlayerTexture(false, false, true);
        }));
        this.func_230480_a_((Widget)new Button(i + 150, j + 190, 140, 20, (ITextComponent)new TranslationTextComponent("gui.locallooks.reset"), p_214132_1_ -> this.changePlayerTexture(true, true, false)));
        this.func_230480_a_((Widget)new Button(i + 150, j + 220, 140, 20, (ITextComponent)new TranslationTextComponent("gui.done"), p_214132_1_ -> Minecraft.func_71410_x().func_147108_a(null)));
    }

    public void func_231152_a_(Minecraft minecraft, int width, int height) {
        String s = this.skinURLField.func_146179_b();
        this.func_231158_b_(minecraft, width, height);
        this.skinURLField.func_146180_a(s);
    }

    private void changePlayerTexture(boolean reset, boolean close, boolean armsOnly) {
        CompoundNBT tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)Minecraft.func_71410_x().field_71439_g);
        boolean prevArms = false;
        String prevURL = "";
        boolean prevNonVanillaSkin = false;
        boolean vanillaSkin = false;
        if (tag.func_74764_b("LocalLooksArms")) {
            prevArms = tag.func_74767_n("LocalLooksArms");
        }
        if (tag.func_74764_b("LocalLooksURL")) {
            prevURL = tag.func_74779_i("LocalLooksURL");
        }
        if (tag.func_74764_b("LocalLooksSkin")) {
            prevNonVanillaSkin = tag.func_74767_n("LocalLooksSkin");
        }
        if (reset) {
            vanillaSkin = true;
            tag.func_74757_a("LocalLooksSkin", false);
            tag.func_74778_a("LocalLooksURL", "");
        } else if (armsOnly) {
            tag.func_74757_a("LocalLooksArms", this.smallArms);
        } else {
            vanillaSkin = false;
            tag.func_74757_a("LocalLooksSkin", true);
            tag.func_74757_a("LocalLooksArms", this.smallArms);
            tag.func_74778_a("LocalLooksURL", this.enteredURL);
        }
        if (this.smallArms != prevArms || !this.enteredURL.equals(prevURL) || prevNonVanillaSkin == vanillaSkin) {
            this.consumeMirror = true;
        }
        CitadelEntityData.setCitadelTag((LivingEntity)Minecraft.func_71410_x().field_71439_g, (CompoundNBT)tag);
        Citadel.sendMSGToServer((Object)new PropertiesMessage("CitadelPatreonConfig", tag, Minecraft.func_71410_x().field_71439_g.func_145782_y()));
        this.transProgress = 5.0f;
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        if (this.consumeMirror) {
            ItemStack stack;
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            ItemStack itemStack = stack = this.offhand ? player.func_184592_cb() : player.func_184614_ca();
            if (stack.func_77973_b() == LocalLooks.MAGIC_MIRROR) {
                LocalLooks.PROXY.displayItemInteractionForPlayer((PlayerEntity)player, stack.func_77946_l());
                if (!this.isCreative() && ((Boolean)ConfigHolder.SERVER.singleUseMirror.get()).booleanValue()) {
                    stack.func_190918_g(1);
                }
            }
            player.func_184185_a(LocalLooks.MIRROR_SOUND, 1.0f, 1.0f);
            LocalLooks.sendMSGToServer(new CloseMirrorMessage(player.func_145782_y(), this.offhand));
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int x, int y, float partialTicks) {
        this.func_230446_a_(matrixStack);
        this.mousePosX = x;
        this.mousePosY = y;
        int k = (this.field_230708_k_ - this.sizePx - 200) / 2;
        int l = (this.field_230709_l_ - this.sizePx + 10) / 2;
        LookCustomizationScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)TITLE_TEXT, (int)(k + 95), (int)(l + 4), (int)0xA0A0A0);
        LookCustomizationScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)ENTER_URL_TEXT, (int)(k + 230), (int)(l + 30), (int)0xA0A0A0);
        if (this.loadingWarning > 0) {
            LookCustomizationScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.locallooks.url_warning_" + this.loadingWarning), (int)(k + 320), (int)(l + 77), (int)0xFF0000);
        }
        this.getMinecraft().func_110434_K().func_110577_a(TEXTURE);
        LookCustomizationScreen.func_238463_a_((MatrixStack)matrixStack, (int)k, (int)l, (float)0.0f, (float)0.0f, (int)this.sizePx, (int)this.sizePx, (int)this.sizePx, (int)this.sizePx);
        InventoryScreen.func_228187_a_((int)(k + 125), (int)(l + 195), (int)70, (float)((float)(k + 125) - this.mousePosX), (float)((float)(l + 195 - 50) - this.mousePosY), (LivingEntity)Minecraft.func_71410_x().field_71439_g);
        this.getMinecraft().func_110434_K().func_110577_a(TEXTURE_SHEEN);
        this.sheenBlit(matrixStack.func_227866_c_().func_227870_a_(), k, l, this.sizePx, this.sizePx, 0.0f, 1.0f, 0.0f, 1.0f, partialTicks);
        matrixStack.func_227860_a_();
        this.skinURLField.func_230430_a_(matrixStack, x, y, partialTicks);
        matrixStack.func_227865_b_();
        super.func_230430_a_(matrixStack, x, y, partialTicks);
    }

    private void sheenBlit(Matrix4f matrix, int x1, int y1, int w, int h, float minU, float maxU, float minV, float maxV, float partialTick) {
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        float offsetB = (float)this.func_230927_p_() + 1000.0f;
        float startAlpha = 0.3f + MathHelper.func_76126_a((float)(((float)Minecraft.func_71410_x().field_71439_g.field_70173_aa + partialTick) * 0.01f)) * 0.1f;
        float progress = 0.2f * MathHelper.func_219799_g((float)partialTick, (float)this.prevTransProgress, (float)this.transProgress);
        float alpha = startAlpha + progress * (1.0f - startAlpha);
        bufferbuilder.func_227888_a_(matrix, (float)x1, (float)y1 + (float)h, offsetB).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(minU, maxV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x1 + (float)w, (float)y1 + (float)h, offsetB).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(maxU, maxV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x1 + (float)w, (float)y1, offsetB).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(maxU, minV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x1, (float)y1, offsetB).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(minU, minV).func_181675_d();
        RenderSystem.enableBlend();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.disableBlend();
    }
}

