/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.locallooks.message;

import com.github.alexthe666.locallooks.LocalLooks;
import com.github.alexthe666.locallooks.config.ConfigHolder;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class CloseMirrorMessage {
    private int entityID;
    private boolean offhand;

    public CloseMirrorMessage() {
    }

    public CloseMirrorMessage(int entityID, boolean offhand) {
        this.entityID = entityID;
        this.offhand = offhand;
    }

    public static void write(CloseMirrorMessage message, PacketBuffer packetBuffer) {
        packetBuffer.writeInt(message.entityID);
        packetBuffer.writeBoolean(message.offhand);
    }

    public static CloseMirrorMessage read(PacketBuffer packetBuffer) {
        return new CloseMirrorMessage(packetBuffer.readInt(), packetBuffer.readBoolean());
    }

    public static class Handler {
        public static void handle(CloseMirrorMessage message, Supplier<NetworkEvent.Context> context) {
            context.get().setPacketHandled(true);
            context.get().enqueueWork(() -> {
                Entity e = ((NetworkEvent.Context)context.get()).getSender().field_70170_p.func_73045_a(message.entityID);
                if (e instanceof PlayerEntity) {
                    ItemStack stack;
                    ItemStack itemStack = stack = message.offhand ? ((PlayerEntity)e).func_184592_cb() : ((PlayerEntity)e).func_184614_ca();
                    if (stack.func_77973_b() == LocalLooks.MAGIC_MIRROR) {
                        LocalLooks.PROXY.displayItemInteractionForPlayer((PlayerEntity)e, stack.func_77946_l());
                        if (!((PlayerEntity)e).func_184812_l_() && ((Boolean)ConfigHolder.SERVER.singleUseMirror.get()).booleanValue()) {
                            stack.func_190918_g(1);
                        }
                    }
                }
            });
        }
    }
}

