/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.locallooks.skin;

import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import com.github.alexthe666.locallooks.skin.texture.MirrorDownloadingTexture;
import com.google.common.hash.Hashing;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;

public class SkinLoader {
    private static final String BACKUP_URL = "https://i.imgur.com/38cvzEc.png";

    private static File getSkinFolder() {
        Path configPath = FMLPaths.GAMEDIR.get();
        Path jsonPath = Paths.get(configPath.toAbsolutePath().toString(), "locallooks/cache");
        return jsonPath.toFile();
    }

    private static ResourceLocation loadSkin(String urlStr, boolean thinArms) {
        String s = Hashing.sha1().hashUnencodedChars((CharSequence)urlStr).toString();
        ResourceLocation resourcelocation = new ResourceLocation("locallooks:skins/" + s + ".png");
        Texture texture = Minecraft.func_71410_x().field_71446_o.func_229267_b_(resourcelocation);
        if (texture == null) {
            File file1 = new File(SkinLoader.getSkinFolder(), s.length() > 2 ? s.substring(0, 2) : "xx");
            File file2 = new File(file1, s);
            URL url = null;
            try {
                url = new URL(urlStr);
                URLConnection urlConn = url.openConnection();
                urlConn.addRequestProperty("User-Agent", "Mozilla/4.76");
                urlStr = urlConn.getURL().toString();
            }
            catch (Exception urlConn) {
                // empty catch block
            }
            MirrorDownloadingTexture downloadingtexture = new MirrorDownloadingTexture(file2, urlStr, DefaultPlayerSkin.func_177335_a(), !thinArms, () -> {});
            Minecraft.func_71410_x().field_71446_o.func_229263_a_(resourcelocation, (Texture)downloadingtexture);
        }
        return resourcelocation;
    }

    public static ResourceLocation getSkinForPlayer(PlayerEntity player) {
        String url = BACKUP_URL;
        boolean arms = false;
        CompoundNBT tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)Minecraft.func_71410_x().field_71439_g);
        if (tag.func_74764_b("LocalLooksURL")) {
            url = tag.func_74779_i("LocalLooksURL");
        }
        if (tag.func_74764_b("LocalLooksArms")) {
            arms = tag.func_74767_n("LocalLooksArms");
        }
        return SkinLoader.loadSkin(url, arms);
    }

    public static int testURL(String urlStr) {
        try {
            URL url = new URL(urlStr);
            URLConnection urlConn = url.openConnection();
            urlConn.addRequestProperty("User-Agent", "Mozilla/4.76");
            String contentType = urlConn.getContentType();
            if (contentType != null && contentType.contains("image")) {
                return 0;
            }
            BufferedImage image = ImageIO.read(url);
            if (image != null) {
                return 0;
            }
            return 1;
        }
        catch (MalformedURLException e) {
            return 2;
        }
        catch (IOException e) {
            return 3;
        }
    }
}

