/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.locallooks.skin.texture;

import com.github.alexthe666.locallooks.config.ConfigHolder;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class MirrorDownloadingTexture
extends SimpleTexture {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private final File cacheFile;
    private final String imageUrl;
    private final boolean legacySkin;
    @Nullable
    private final Runnable processTask;
    @Nullable
    private CompletableFuture<?> future;
    private boolean textureUploaded;

    public MirrorDownloadingTexture(@Nullable File cacheFileIn, String imageUrlIn, ResourceLocation textureResourceLocation, boolean legacySkinIn, @Nullable Runnable processTaskIn) {
        super(textureResourceLocation);
        this.cacheFile = cacheFileIn;
        this.imageUrl = imageUrlIn;
        this.legacySkin = legacySkinIn;
        this.processTask = processTaskIn;
    }

    private void setImage(NativeImage nativeImageIn) {
        if (this.processTask != null) {
            this.processTask.run();
        }
        Minecraft.func_71410_x().execute(() -> {
            this.textureUploaded = true;
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> this.upload(nativeImageIn));
            } else {
                this.upload(nativeImageIn);
            }
        });
    }

    private void upload(NativeImage imageIn) {
        TextureUtil.func_225680_a_((int)this.func_110552_b(), (int)imageIn.func_195702_a(), (int)imageIn.func_195714_b());
        imageIn.func_195697_a(0, 0, 0, true);
    }

    public void func_195413_a(IResourceManager manager) throws IOException {
        Minecraft.func_71410_x().execute(() -> {
            if (!this.textureUploaded) {
                try {
                    super.func_195413_a(manager);
                }
                catch (IOException ioexception) {
                    LOGGER.warn("Failed to load texture: {}", (Object)this.field_110568_b, (Object)ioexception);
                }
                this.textureUploaded = true;
            }
        });
        if (this.future == null) {
            NativeImage nativeimage;
            if (this.cacheFile != null && this.cacheFile.isFile()) {
                LOGGER.debug("Loading http texture from local cache ({})", (Object)this.cacheFile);
                FileInputStream fileinputstream = new FileInputStream(this.cacheFile);
                nativeimage = this.loadTexture(fileinputstream);
            } else {
                nativeimage = null;
            }
            if (nativeimage != null) {
                this.setImage(nativeimage);
            } else {
                this.future = CompletableFuture.runAsync(() -> {
                    URLConnection urlConn = null;
                    LOGGER.debug("Downloading http texture from {} to {}", (Object)this.imageUrl, (Object)this.cacheFile);
                    try {
                        URL url = new URL(this.imageUrl);
                        urlConn = url.openConnection();
                        urlConn.setDoInput(true);
                        urlConn.setDoOutput(false);
                        urlConn.addRequestProperty("User-Agent", "Mozilla/4.76");
                        urlConn.connect();
                        String contentType = urlConn.getContentType();
                        if (contentType != null && contentType.contains("image")) {
                            InputStream inputstream;
                            if (this.cacheFile != null) {
                                FileUtils.copyInputStreamToFile((InputStream)urlConn.getInputStream(), (File)this.cacheFile);
                                inputstream = new FileInputStream(this.cacheFile);
                            } else {
                                inputstream = urlConn.getInputStream();
                            }
                            Minecraft.func_71410_x().execute(() -> {
                                NativeImage nativeimage1 = this.loadTexture(inputstream);
                                if (nativeimage1 != null) {
                                    this.setImage(nativeimage1);
                                }
                            });
                            return;
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.warn("HTTP Error texture: " + this.imageUrl);
                        LOGGER.warn("Couldn't download http texture", (Throwable)exception);
                        return;
                    }
                    finally {
                        if (urlConn != null && urlConn instanceof HttpURLConnection) {
                            ((HttpURLConnection)urlConn).disconnect();
                        }
                    }
                }, Util.func_215072_e());
            }
        }
    }

    @Nullable
    private NativeImage loadTexture(InputStream inputStreamIn) {
        NativeImage nativeimage = null;
        try {
            nativeimage = NativeImage.func_195713_a((InputStream)inputStreamIn);
            if (this.legacySkin) {
                nativeimage = MirrorDownloadingTexture.processLegacySkin(nativeimage);
            }
        }
        catch (IOException ioexception) {
            LOGGER.warn("Error while loading the skin texture", (Throwable)ioexception);
        }
        return nativeimage;
    }

    private static NativeImage processLegacySkin(NativeImage nativeImageIn) {
        boolean transparency;
        boolean flag;
        boolean bl = flag = nativeImageIn.func_195714_b() == 32;
        if (flag) {
            NativeImage nativeimage = new NativeImage(64, 64, true);
            nativeimage.func_195703_a(nativeImageIn);
            nativeImageIn.close();
            nativeImageIn = nativeimage;
            nativeimage.func_195715_a(0, 32, 64, 32, 0);
            nativeimage.func_195699_a(4, 16, 16, 32, 4, 4, true, false);
            nativeimage.func_195699_a(8, 16, 16, 32, 4, 4, true, false);
            nativeimage.func_195699_a(0, 20, 24, 32, 4, 12, true, false);
            nativeimage.func_195699_a(4, 20, 16, 32, 4, 12, true, false);
            nativeimage.func_195699_a(8, 20, 8, 32, 4, 12, true, false);
            nativeimage.func_195699_a(12, 20, 16, 32, 4, 12, true, false);
            nativeimage.func_195699_a(44, 16, -8, 32, 4, 4, true, false);
            nativeimage.func_195699_a(48, 16, -8, 32, 4, 4, true, false);
            nativeimage.func_195699_a(40, 20, 0, 32, 4, 12, true, false);
            nativeimage.func_195699_a(44, 20, -8, 32, 4, 12, true, false);
            nativeimage.func_195699_a(48, 20, -16, 32, 4, 12, true, false);
            nativeimage.func_195699_a(52, 20, -8, 32, 4, 12, true, false);
        }
        if (transparency = ((Boolean)ConfigHolder.CLIENT.transparentSkins.get()).booleanValue()) {
            MirrorDownloadingTexture.setAreaTransparent(nativeImageIn, 0, 0, 32, 16);
        } else {
            MirrorDownloadingTexture.setAreaOpaque(nativeImageIn, 0, 0, 32, 16);
        }
        if (flag) {
            MirrorDownloadingTexture.setAreaTransparent(nativeImageIn, 32, 0, 64, 32);
        }
        if (transparency) {
            MirrorDownloadingTexture.setAreaTransparent(nativeImageIn, 0, 16, 64, 32);
            MirrorDownloadingTexture.setAreaTransparent(nativeImageIn, 16, 48, 48, 64);
        } else {
            MirrorDownloadingTexture.setAreaOpaque(nativeImageIn, 0, 16, 64, 32);
            MirrorDownloadingTexture.setAreaOpaque(nativeImageIn, 16, 48, 48, 64);
        }
        return nativeImageIn;
    }

    private static void setAreaTransparent(NativeImage image, int x, int y, int width, int height) {
        for (int i = x; i < width; ++i) {
            for (int j = y; j < height; ++j) {
                int k = image.func_195709_a(i, j);
                if ((k >> 24 & 0xFF) >= 128) continue;
                return;
            }
        }
        for (int l = x; l < width; ++l) {
            for (int i1 = y; i1 < height; ++i1) {
                image.func_195700_a(l, i1, image.func_195709_a(l, i1) & 0xFFFFFF);
            }
        }
    }

    private static void setAreaOpaque(NativeImage image, int x, int y, int width, int height) {
        for (int i = x; i < width; ++i) {
            for (int j = y; j < height; ++j) {
                image.func_195700_a(i, j, image.func_195709_a(i, j) | 0xFF000000);
            }
        }
    }
}

