/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.gui.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import mcjty.lostcities.config.Configuration;
import mcjty.lostcities.gui.GuiLCConfig;
import mcjty.lostcities.gui.elements.GuiElement;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class FloatElement
extends GuiElement {
    private final GuiLCConfig gui;
    private String label = null;
    private String prefix = null;
    private final TextFieldWidget field;
    private final String attribute;

    public FloatElement(final GuiLCConfig gui, String page, int x, int y, final String attribute) {
        super(page, x, y);
        this.gui = gui;
        this.attribute = attribute;
        Float c = gui.getLocalSetup().get().map(h -> (Float)h.toConfiguration().get(attribute)).orElse(Float.valueOf(0.0f));
        this.field = new TextFieldWidget(gui.getFont(), x, y, 45, 16, (ITextComponent)new StringTextComponent(Float.toString(c.floatValue()))){

            public void func_230443_a_(MatrixStack stack, int x, int y) {
                gui.getLocalSetup().get().ifPresent(h -> gui.func_238652_a_(stack, h.toConfiguration().getValue(attribute).getComment(), x, y));
            }
        };
        this.field.func_212954_a(s -> gui.getLocalSetup().get().ifPresent(profile -> {
            Configuration configuration = profile.toConfiguration();
            float value = 0.0f;
            try {
                value = Float.parseFloat(s);
            }
            catch (NumberFormatException e) {
                return;
            }
            Configuration.Value val = configuration.getValue(attribute);
            val.set(Float.valueOf(value));
            if (val.constrain()) {
                this.setValue(val.get());
            }
            profile.copyFromConfiguration(configuration);
            gui.refreshPreview();
        }));
        gui.addWidget(this.field);
    }

    public FloatElement prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public FloatElement label(String label) {
        this.label = label;
        return this;
    }

    @Override
    public void tick() {
        this.field.func_146178_a();
    }

    @Override
    public void render(MatrixStack stack) {
        if (this.field.field_230694_p_) {
            if (this.label != null) {
                GuiLCConfig.func_238476_c_((MatrixStack)stack, (FontRenderer)this.gui.getFont(), (String)this.label, (int)10, (int)(this.y + 5), (int)-1);
            }
            if (this.prefix != null) {
                GuiLCConfig.func_238476_c_((MatrixStack)stack, (FontRenderer)this.gui.getFont(), (String)this.prefix, (int)(this.x - 8), (int)(this.y + 5), (int)-1);
            }
        }
    }

    @Override
    public void update() {
        this.gui.getLocalSetup().get().ifPresent(profile -> {
            Object result = profile.toConfiguration().get(this.attribute);
            this.setValue(result);
        });
    }

    private void setValue(Object result) {
        if (result instanceof Float) {
            this.field.func_146180_a(Float.toString(((Float)result).floatValue()));
        } else if (result instanceof Integer) {
            this.field.func_146180_a(Integer.toString((Integer)result));
        }
    }

    @Override
    public void setEnabled(boolean b) {
        this.field.func_146184_c(b);
    }

    @Override
    public void setBasedOnMode(String mode) {
        this.field.func_146189_e(this.page.equalsIgnoreCase(mode));
    }
}

