/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import mcjty.lostcities.config.LostCityConfiguration;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.setup.Config;
import mcjty.lostcities.setup.Registration;
import mcjty.lostcities.worldgen.DefaultDimensionInfo;
import mcjty.lostcities.worldgen.IDimensionInfo;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;

public class LostCityFeature
extends Feature<NoFeatureConfig> {
    private Map<RegistryKey<World>, IDimensionInfo> dimensionInfo = new HashMap<RegistryKey<World>, IDimensionInfo>();
    public static ConfiguredFeature<?, ?> LOSTCITY_CONFIGURED_FEATURE;

    public static void registerConfiguredFeatures() {
        Registry registry = WorldGenRegistries.field_243653_e;
        LOSTCITY_CONFIGURED_FEATURE = Registration.LOSTCITY_FEATURE.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_202429_e).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(1, 0, 1)));
        Registry.func_218322_a((Registry)registry, (ResourceLocation)new ResourceLocation("lostcities", "configured_feature"), LOSTCITY_CONFIGURED_FEATURE);
    }

    public LostCityFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean place(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        IDimensionInfo diminfo;
        if (world instanceof WorldGenRegion && (diminfo = this.getDimensionInfo(world)) != null) {
            WorldGenRegion region = (WorldGenRegion)world;
            int chunkX = region.func_201679_a();
            int chunkZ = region.func_201680_b();
            diminfo.setWorld(world);
            diminfo.getFeature().generate(region, region.func_212866_a_(chunkX, chunkZ));
            return true;
        }
        return false;
    }

    @Nullable
    public IDimensionInfo getDimensionInfo(ISeedReader world) {
        RegistryKey type = world.func_201672_e().func_234923_W_();
        String profileName = Config.getProfileForDimension((RegistryKey<World>)type);
        if (profileName != null) {
            if (!this.dimensionInfo.containsKey(type)) {
                LostCityProfile profile = LostCityConfiguration.standardProfiles.get(profileName);
                DefaultDimensionInfo diminfo = new DefaultDimensionInfo(world, profile);
                this.dimensionInfo.put((RegistryKey<World>)type, diminfo);
            }
            return this.dimensionInfo.get(type);
        }
        return null;
    }
}

