/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.cityassets;

import com.google.common.base.Predicates;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import mcjty.lostcities.api.ILostCityAsset;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.varia.Tools;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.lost.BiomeInfo;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class WorldStyle
implements ILostCityAsset {
    private String name;
    private String outsideStyle;
    private final List<Pair<Predicate<Info>, Pair<Float, String>>> cityStyleSelector = new ArrayList<Pair<Predicate<Info>, Pair<Float, String>>>();

    public WorldStyle(JsonObject object) {
        this.readFromJSon(object);
    }

    public WorldStyle(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void readFromJSon(JsonObject object) {
        this.name = object.get("name").getAsString();
        this.outsideStyle = object.get("outsidestyle").getAsString();
        JsonArray array = object.get("citystyles").getAsJsonArray();
        for (JsonElement element : array) {
            JsonObject o = element.getAsJsonObject();
            float factor = o.get("factor").getAsFloat();
            String building = o.get("citystyle").getAsString();
            Object predicate = Predicates.alwaysTrue();
            if (o.has("biomes")) {
                JsonArray ar = o.get("biomes").getAsJsonArray();
                HashSet<ResourceLocation> biomes = new HashSet<ResourceLocation>();
                for (JsonElement el : ar) {
                    Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(el.getAsString()));
                    if (biome == null) continue;
                    biomes.add(Tools.getBiomeId(biome));
                }
                predicate = info -> this.hasBiomes((Info)info, (Set<ResourceLocation>)biomes);
            }
            this.cityStyleSelector.add((Pair<Predicate<Info>, Pair<Float, String>>)Pair.of((Object)predicate, (Object)Pair.of((Object)Float.valueOf(factor), (Object)building)));
        }
    }

    private boolean isValidBiome(Set<ResourceLocation> biomeSet, Biome biome) {
        return biomeSet.contains(Tools.getBiomeId(biome));
    }

    private boolean hasBiomes(Info info, Set<ResourceLocation> biomeSet) {
        Biome biome = info.biome;
        return this.isValidBiome(biomeSet, biome);
    }

    public String getOutsideStyle() {
        return this.outsideStyle;
    }

    public JsonObject writeToJSon() {
        JsonObject object = new JsonObject();
        object.add("type", (JsonElement)new JsonPrimitive("worldstyle"));
        object.add("name", (JsonElement)new JsonPrimitive(this.name));
        object.add("outsidestyle", (JsonElement)new JsonPrimitive(this.outsideStyle));
        JsonArray array = new JsonArray();
        for (Pair<Predicate<Info>, Pair<Float, String>> pair : this.cityStyleSelector) {
            JsonObject o = new JsonObject();
            Pair ff = (Pair)pair.getValue();
            o.add("factor", (JsonElement)new JsonPrimitive((Number)ff.getKey()));
            o.add("citystyle", (JsonElement)new JsonPrimitive((String)ff.getValue()));
            array.add((JsonElement)o);
        }
        object.add("citystyles", (JsonElement)array);
        return object;
    }

    public String getRandomCityStyle(IDimensionInfo provider, int chunkX, int chunkZ, Random random) {
        Biome biomes = BiomeInfo.getBiomeInfo(provider, new ChunkCoord(provider.getType(), chunkX, chunkZ)).getMainBiome();
        Info info = new Info(biomes, chunkX, chunkZ);
        ArrayList<Pair<Float, String>> ct = new ArrayList<Pair<Float, String>>();
        for (Pair<Predicate<Info>, Pair<Float, String>> pair : this.cityStyleSelector) {
            if (!((Predicate)pair.getKey()).test(info)) continue;
            ct.add((Pair<Float, String>)pair.getValue());
        }
        return Tools.getRandomFromList(random, ct);
    }

    private static class Info {
        private Biome biome;
        private int chunkX;
        private int chunkZ;

        public Info(Biome biome, int chunkX, int chunkZ) {
            this.biome = biome;
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
        }
    }
}

