/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.dummmmmmy.entity;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.mehvahdjukaar.dummmmmmy.common.Configs;
import net.mehvahdjukaar.dummmmmmy.common.NetworkHandler;
import net.mehvahdjukaar.dummmmmmy.entity.DummyNumberEntity;
import net.mehvahdjukaar.dummmmmmy.setup.Registry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeEntity;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fmllegacy.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fmllegacy.network.FMLPlayMessages;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public class TargetDummyEntity
extends Mob
implements IEntityAdditionalSpawnData,
IForgeEntity {
    public float prevLimbSwing = 0.0f;
    public float prevShakeAmount = 0.0f;
    public float shakeAmount = 0.0f;
    public float lastDamage;
    public int lastDamageTick;
    public int firstDamageTick;
    public float damageTaken;
    public boolean critical = false;
    public MobAttribute mobType = MobAttribute.UNDEFINED;
    private final List<ServerPlayer> currentlyAttacking = new ArrayList<ServerPlayer>();
    private int damageNumberPos = 0;
    public boolean sheared = false;
    private final NonNullList<ItemStack> lastArmorItem = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);

    public TargetDummyEntity(FMLPlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<TargetDummyEntity>)((EntityType)Registry.TARGET_DUMMY.get()), world);
    }

    public TargetDummyEntity(EntityType<TargetDummyEntity> type, Level world) {
        super(type, world);
    }

    public TargetDummyEntity(Level world) {
        this((EntityType<TargetDummyEntity>)((EntityType)Registry.TARGET_DUMMY.get()), world);
        this.f_21364_ = 0;
        Arrays.fill(this.f_21348_, 1.1f);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.sheared);
        this.updateOnLoadServer();
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.sheared = additionalData.readBoolean();
        this.updateOnLoadClient();
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Type", this.mobType.ordinal());
        tag.m_128405_("NumberPos", this.damageNumberPos);
        tag.m_128379_("Sheared", this.sheared);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.mobType = MobAttribute.values()[tag.m_128451_("Type")];
        this.damageNumberPos = tag.m_128451_("NumberPos");
        this.sheared = tag.m_128471_("Sheared");
    }

    public void updateOnLoadClient() {
        float r;
        this.f_20886_ = this.f_20885_ = (r = this.m_146908_());
        this.f_19859_ = r;
        this.f_20884_ = this.f_20883_ = r;
    }

    public void updateOnLoadServer() {
        this.applyEquipmentModifiers();
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        boolean invchanged = false;
        if (!player.m_5833_() && player.m_150110_().f_35938_) {
            ItemStack itemstack = player.m_21120_(hand);
            EquipmentSlot equipmentslottype = TargetDummyEntity.m_147233_((ItemStack)itemstack);
            Item item = itemstack.m_41720_();
            if (item instanceof BannerItem || this.isPumpkin(item) || item.canEquip(itemstack, EquipmentSlot.HEAD, (Entity)this)) {
                equipmentslottype = EquipmentSlot.HEAD;
            }
            if (itemstack.m_41619_() && hand == InteractionHand.MAIN_HAND) {
                equipmentslottype = this.getClickedSlot(vec);
                if (this.m_21033_(equipmentslottype)) {
                    if (player.f_19853_.f_46443_) {
                        return InteractionResult.CONSUME;
                    }
                    this.unequipArmor(player, equipmentslottype, itemstack, hand);
                    invchanged = true;
                }
            } else if (equipmentslottype.m_20743_() == EquipmentSlot.Type.ARMOR) {
                if (player.f_19853_.f_46443_) {
                    return InteractionResult.CONSUME;
                }
                this.equipArmor(player, equipmentslottype, itemstack, hand);
                invchanged = true;
            } else if (item instanceof ShearsItem && !this.sheared) {
                if (player.f_19853_.f_46443_) {
                    return InteractionResult.CONSUME;
                }
                this.sheared = true;
                if (!this.f_19853_.f_46443_) {
                    NetworkHandler.sendToAllTracking((Entity)this, (ServerLevel)this.f_19853_, new NetworkHandler.PacketChangeSkin(this.m_142049_(), true));
                }
                return InteractionResult.SUCCESS;
            }
            if (invchanged) {
                this.setLastArmorItem(equipmentslottype, itemstack);
                if (!this.f_19853_.f_46443_) {
                    NetworkHandler.sendToAllTracking((Entity)this, (ServerLevel)this.f_19853_, new NetworkHandler.PacketSyncEquip(this.m_142049_(), equipmentslottype.m_20749_(), this.m_6844_(equipmentslottype)));
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void unequipArmor(Player player, EquipmentSlot slot, ItemStack stack, InteractionHand hand) {
        ItemStack itemstack = this.m_6844_(slot);
        ItemStack itemstack2 = itemstack.m_41777_();
        player.m_21008_(hand, itemstack2);
        this.m_8061_(slot, stack);
        this.m_21204_().m_22161_(itemstack2.m_41638_(slot));
        if (slot == EquipmentSlot.HEAD) {
            this.mobType = MobAttribute.UNDEFINED;
        }
    }

    private void equipArmor(Player player, EquipmentSlot slot, ItemStack stack, InteractionHand hand) {
        ItemStack currentItem = this.m_6844_(slot);
        ItemStack newItem = stack.m_41777_();
        newItem.m_41764_(1);
        player.m_21008_(hand, ItemUtils.m_41817_((ItemStack)stack.m_41777_(), (Player)player, (ItemStack)currentItem, (boolean)player.m_7500_()));
        this.m_147218_(newItem);
        this.m_8061_(slot, newItem);
        this.m_21204_().m_22178_(newItem.m_41638_(slot));
        if (slot == EquipmentSlot.HEAD) {
            this.mobType = this.isUndeadSkull(newItem) ? MobAttribute.UNDEAD : (newItem.m_41720_() == Items.f_42354_ ? MobAttribute.WATER : (newItem.m_41720_() == Items.f_42683_ ? MobAttribute.ARTHROPOD : (ItemStack.m_41728_((ItemStack)newItem, (ItemStack)Raid.m_37779_()) ? MobAttribute.ILLAGER : (this.isPumpkin(newItem.m_41720_()) ? MobAttribute.SCARECROW : MobAttribute.UNDEFINED))));
        }
    }

    private boolean isPumpkin(Item item) {
        if (item instanceof BlockItem) {
            Block block = ((BlockItem)item).m_40614_();
            String name = item.getRegistryName().m_135815_();
            return block instanceof CarvedPumpkinBlock || name.contains("pumpkin") || name.contains("jack_o");
        }
        return false;
    }

    private boolean isUndeadSkull(ItemStack itemstack) {
        Item i = itemstack.m_41720_();
        return i == Items.f_42679_ || i == Items.f_42678_ || i == Items.f_42681_;
    }

    public boolean isScarecrow() {
        return this.mobType == MobAttribute.SCARECROW;
    }

    private EquipmentSlot getClickedSlot(Vec3 p_190772_1_) {
        EquipmentSlot equipmentslottype = EquipmentSlot.MAINHAND;
        double d0 = p_190772_1_.f_82480_;
        EquipmentSlot equipmentslottype1 = EquipmentSlot.FEET;
        if (d0 >= 0.1 && d0 < 0.55 && this.m_21033_(equipmentslottype1)) {
            equipmentslottype = EquipmentSlot.FEET;
        } else if (d0 >= 0.9 && d0 < 1.6 && this.m_21033_(EquipmentSlot.CHEST)) {
            equipmentslottype = EquipmentSlot.CHEST;
        } else if (d0 >= 0.4 && d0 < 1.2000000000000002 && this.m_21033_(EquipmentSlot.LEGS)) {
            equipmentslottype = EquipmentSlot.LEGS;
        } else if (d0 >= 1.6 && this.m_21033_(EquipmentSlot.HEAD)) {
            equipmentslottype = EquipmentSlot.HEAD;
        }
        return equipmentslottype;
    }

    private void setLastArmorItem(EquipmentSlot type, ItemStack stack) {
        this.lastArmorItem.set(type.m_20749_(), (Object)stack);
    }

    public void applyEquipmentModifiers() {
        if (!this.f_19853_.f_46443_) {
            for (EquipmentSlot equipmentslottype : EquipmentSlot.values()) {
                if (equipmentslottype.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                ItemStack itemstack = (ItemStack)this.lastArmorItem.get(equipmentslottype.m_20749_());
                ItemStack itemstack1 = this.m_6844_(equipmentslottype);
                if (ItemStack.m_41728_((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
                if (!itemstack1.equals(itemstack, true)) {
                    MinecraftForge.EVENT_BUS.post((Event)new LivingEquipmentChangeEvent((LivingEntity)this, equipmentslottype, itemstack, itemstack1));
                }
                if (!itemstack.m_41619_()) {
                    this.m_21204_().m_22161_(itemstack.m_41638_(equipmentslottype));
                }
                if (itemstack1.m_41619_()) continue;
                this.m_21204_().m_22178_(itemstack1.m_41638_(equipmentslottype));
            }
        }
    }

    public void m_5907_() {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack armor;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (armor = this.m_6844_(slot)).m_41619_()) continue;
            this.m_5552_(armor, 1.0f);
        }
    }

    public void dismantle(boolean drops) {
        if (!this.f_19853_.f_46443_) {
            if (drops) {
                this.m_5907_();
                this.m_20000_((ItemLike)Registry.DUMMY_ITEM.get(), 1);
            }
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_5592_(), this.m_5720_(), 1.0f, 1.0f);
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50705_.m_49966_()), this.m_20185_(), this.m_20227_(0.6666666666666666), this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void m_6074_() {
        this.dismantle(true);
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)Registry.DUMMY_ITEM.get());
    }

    public boolean m_6469_(DamageSource source, float damage) {
        if (!ForgeHooks.onLivingAttack((LivingEntity)this, (DamageSource)source, (float)damage)) {
            return false;
        }
        if (this.m_6673_(source)) {
            return false;
        }
        if (source == DamageSource.f_19317_) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            return true;
        }
        if (source == DamageSource.f_19312_ || source == DamageSource.f_19310_) {
            return false;
        }
        if (source.m_7640_() instanceof WitherBoss || source.m_7639_() instanceof WitherBoss) {
            this.dismantle(true);
            return true;
        }
        if (source.m_19384_() && this.m_21023_(MobEffects.f_19607_)) {
            return false;
        }
        if (!(source != DamageSource.f_19321_ && source != DamageSource.f_19322_ || this.m_6844_(EquipmentSlot.HEAD).m_41619_())) {
            damage *= 0.75f;
        }
        if (source.f_19326_.equals("player") || source.m_7639_() instanceof Player) {
            ServerPlayer sp;
            Player player = (Player)source.m_7639_();
            if (!this.f_19853_.f_46443_ && !this.currentlyAttacking.contains(sp = (ServerPlayer)player)) {
                this.currentlyAttacking.add(sp);
            }
            if (player.m_6144_() && player.m_21205_().m_41619_()) {
                this.dismantle(!player.m_7500_());
                return false;
            }
        }
        if ((float)this.f_19802_ > 10.0f) {
            if (damage <= this.lastDamage) {
                return false;
            }
            float ld = this.lastDamage;
            this.lastDamage = damage;
            damage -= ld;
        } else {
            this.m_6677_(source);
            this.lastDamage = damage;
            this.f_19802_ = 20;
            this.f_20917_ = 10;
        }
        this.f_20916_ = 0;
        if (!this.f_19853_.f_46443_ && (damage = ForgeHooks.onLivingHurt((LivingEntity)this, (DamageSource)source, (float)damage)) > 0.0f) {
            damage = this.m_21161_(source, damage);
            float f1 = damage = this.m_6515_(source, damage);
            damage = Math.max(damage - this.m_6103_(), 0.0f);
            this.m_7911_(this.m_6103_() - (f1 - damage));
        }
        if (this.lastDamageTick == this.f_19797_) {
            this.lastDamage += damage;
            this.f_20925_ += damage;
            this.f_20925_ = Math.min(this.f_20925_, 60.0f);
        } else {
            this.f_20925_ = Math.min(damage, 60.0f);
            this.lastDamage = damage;
            this.lastDamageTick = this.f_19797_;
        }
        if (!this.f_19853_.f_46443_) {
            this.showDamageDealt(damage, this.getDamageType(source));
            this.critical = false;
        }
        return true;
    }

    private void showDamageDealt(float damage, DamageType type) {
        NetworkHandler.sendToAllTracking((Entity)this, (ServerLevel)this.f_19853_, new NetworkHandler.PacketDamageNumber(this.m_142049_(), damage, this.f_20925_));
        DummyNumberEntity number = new DummyNumberEntity(damage, type, this.damageNumberPos++, this.f_19853_);
        number.m_7678_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 0.0f, 0.0f);
        this.f_19853_.m_7967_((Entity)number);
        this.damageTaken += damage;
        if (this.firstDamageTick == 0) {
            this.firstDamageTick = this.f_19797_;
        }
    }

    public void m_8119_() {
        float trueDamage;
        if (this.lastDamageTick + 1 == this.f_19797_ && !this.f_19853_.f_46443_ && (trueDamage = this.m_21233_() - this.m_21223_()) > 0.0f) {
            this.m_5634_(trueDamage);
            this.showDamageDealt(trueDamage, DamageType.TRUE);
        }
        BlockPos onPos = this.m_20097_();
        if (this.f_19853_.m_46467_() % 20L == 0L && !this.f_19853_.f_46443_ && this.f_19853_.m_46859_(onPos)) {
            this.dismantle(true);
            return;
        }
        this.m_20242_(true);
        BlockState onState = this.f_19853_.m_8055_(onPos);
        onState.m_60734_().m_141947_(this.f_19853_, onPos, onState, (Entity)this);
        this.m_6075_();
        this.f_19853_.m_46473_().m_6180_("travel");
        this.m_7023_(new Vec3((double)this.f_20900_, (double)this.f_20901_, (double)this.f_20902_));
        this.f_19853_.m_46473_().m_7238_();
        this.f_19853_.m_46473_().m_6180_("push");
        this.m_6138_();
        this.f_19853_.m_46473_().m_7238_();
        if (this.f_19853_.f_46443_) {
            this.f_20916_ = 0;
            this.prevShakeAmount = this.shakeAmount;
            this.prevLimbSwing = this.f_20925_;
            if (this.f_20925_ > 0.0f) {
                this.shakeAmount += 1.0f;
                this.f_20925_ -= 0.8f;
                if (this.f_20925_ <= 0.0f) {
                    this.shakeAmount = 0.0f;
                    this.f_20925_ = 0.0f;
                }
            }
        } else if (this.damageTaken > 0.0f) {
            boolean flag;
            boolean isdynamic = Configs.cached.DYNAMIC_DPS;
            boolean bl = isdynamic ? this.f_19797_ == this.lastDamageTick + 1 : (flag = this.f_19797_ - this.lastDamageTick > 60);
            if (flag && this.firstDamageTick < this.lastDamageTick) {
                float seconds = (float)(this.lastDamageTick - this.firstDamageTick) / 20.0f + 1.0f;
                float dps = this.damageTaken / seconds;
                for (ServerPlayer p : this.currentlyAttacking) {
                    if (!(p.m_20270_((Entity)this) < 64.0f)) continue;
                    p.m_5661_((Component)new TranslatableComponent("message.dummmmmmy.dps", new Object[]{new DecimalFormat("#.##").format(dps)}), true);
                }
            }
            if (this.f_19797_ - this.lastDamageTick > 60) {
                this.currentlyAttacking.clear();
                this.damageTaken = 0.0f;
                this.firstDamageTick = 0;
            }
        }
    }

    public void m_20256_(Vec3 motionIn) {
    }

    public void m_147240_(double p_147241_, double p_147242_, double p_147243_) {
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6040_() {
        return true;
    }

    protected boolean m_6107_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6087_() {
        return super.m_6087_();
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void m_20242_(boolean ignored) {
        super.m_20242_(true);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return SoundEvents.f_11683_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_11681_;
    }

    public MobType m_6336_() {
        return this.mobType.get();
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22280_, 0.0);
    }

    public DamageType getDamageType(DamageSource source) {
        if (this.critical) {
            return DamageType.CRIT;
        }
        if (source == DamageSource.f_19323_) {
            return DamageType.DRAGON;
        }
        if (source == DamageSource.f_19320_) {
            return DamageType.WITHER;
        }
        if (source.f_19326_.equals("explosion") || source.f_19326_.equals("explosion.player") || source.m_19372_()) {
            return DamageType.EXPLOSION;
        }
        if (source.f_19326_.equals("indirectMagic")) {
            return DamageType.IND_MAGIC;
        }
        if (source.f_19326_.equals("trident")) {
            return DamageType.TRIDENT;
        }
        if (source == DamageSource.f_19309_ || source == DamageSource.f_19308_ || source == DamageSource.f_19307_ || source == DamageSource.f_19305_ || source.m_19384_()) {
            return DamageType.FIRE;
        }
        if (source == DamageSource.f_19319_ || source.m_19387_()) {
            return DamageType.MAGIC;
        }
        if (source == DamageSource.f_19306_) {
            return DamageType.LIGHTNING;
        }
        if (source == DamageSource.f_19314_ || source == DamageSource.f_19325_) {
            return DamageType.CACTUS;
        }
        return DamageType.GENERIC;
    }

    private static enum MobAttribute {
        UNDEFINED,
        UNDEAD,
        WATER,
        ILLAGER,
        ARTHROPOD,
        SCARECROW;


        public MobType get() {
            return switch (this) {
                case UNDEFINED, SCARECROW -> MobType.f_21640_;
                case UNDEAD -> MobType.f_21641_;
                case WATER -> MobType.f_21644_;
                case ILLAGER -> MobType.f_21643_;
                case ARTHROPOD -> MobType.f_21642_;
                default -> throw new IncompatibleClassChangeError();
            };
        }
    }

    public static enum DamageType {
        GENERIC,
        CRIT,
        DRAGON,
        WITHER,
        EXPLOSION,
        MAGIC,
        IND_MAGIC,
        TRIDENT,
        FIRE,
        LIGHTNING,
        CACTUS,
        TRUE;


        public int getColor() {
            return switch (this) {
                case CRIT -> Configs.cached.DAMAGE_CRIT;
                case FIRE -> Configs.cached.DAMAGE_FIRE;
                case MAGIC -> Configs.cached.DAMAGE_MAGIC;
                case CACTUS -> Configs.cached.DAMAGE_CACTUS;
                case DRAGON -> Configs.cached.DAMAGE_DRAGON;
                case WITHER -> Configs.cached.DAMAGE_WITHER;
                case GENERIC -> Configs.cached.DAMAGE_GENERIC;
                case TRIDENT -> Configs.cached.DAMAGE_TRIDENT;
                case EXPLOSION -> Configs.cached.DAMAGE_EXPLOSION;
                case IND_MAGIC -> Configs.cached.DAMAGE_IND_MAGIC;
                case LIGHTNING -> Configs.cached.DAMAGE_LIGHTNING;
                case TRUE -> Configs.cached.DAMAGE_TRUE;
                default -> throw new IncompatibleClassChangeError();
            };
        }
    }
}

