/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.dummmmmmy.common;

import net.mehvahdjukaar.dummmmmmy.common.Configs;
import net.mehvahdjukaar.dummmmmmy.entity.TargetDummyEntity;
import net.mehvahdjukaar.dummmmmmy.setup.ModRegistry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Events {
    @SubscribeEvent
    public static void onEntityCriticalHit(CriticalHitEvent event) {
        if (event != null && event.getEntity() != null) {
            Entity target = event.getTarget();
            if ((double)event.getDamageModifier() == 1.5 && target instanceof TargetDummyEntity) {
                TargetDummyEntity dummy = (TargetDummyEntity)target;
                dummy.critical = true;
            }
        }
    }

    public static boolean isScared(Entity entity) {
        String name = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).toString();
        return (entity instanceof Animal || Configs.cachedServer.WHITELIST.contains(name)) && !Configs.cachedServer.BLACKLIST.contains(name);
    }

    public static boolean isScarecrowInRange(Entity entity, Level world) {
        return !world.m_142425_((EntityTypeTest)ModRegistry.TARGET_DUMMY.get(), entity.m_20191_().m_82400_(10.0), TargetDummyEntity::isScarecrow).isEmpty();
    }

    @SubscribeEvent
    public static void onCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (!(event.getLevel() instanceof Level)) {
            return;
        }
        Level world = event.getEntity().f_19853_;
        Mob entity = event.getEntity();
        if (Events.isScared((Entity)entity) && Events.isScarecrowInRange((Entity)entity, world)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        if (event.getLevel() == null) {
            return;
        }
        Entity e = event.getEntity();
        if (e instanceof PathfinderMob) {
            PathfinderMob mob = (PathfinderMob)e;
            if (Events.isScared(e)) {
                mob.f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal(mob, TargetDummyEntity.class, (float)Configs.cachedServer.RADIUS, 1.0, 1.3, d -> ((TargetDummyEntity)((Object)d)).isScarecrow()));
            }
        }
    }
}

