/*
 * Decompiled with CFR 0.152.
 */
package at.feldim2425.moreoverlays.api.lightoverlay;

import at.feldim2425.moreoverlays.api.lightoverlay.ILightScanner;
import at.feldim2425.moreoverlays.config.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import org.apache.commons.lang3.tuple.Pair;

public abstract class LightScannerBase
implements ILightScanner {
    protected List<Pair<BlockPos, Byte>> overlayCache = new ArrayList<Pair<BlockPos, Byte>>();

    @Override
    public void update(PlayerEntity player) {
        int px = (int)Math.floor(player.func_226277_ct_());
        int py = (int)Math.floor(player.func_226278_cu_());
        int pz = (int)Math.floor(player.func_226281_cx_());
        int y1 = py - (Integer)Config.light_DownRange.get();
        int y2 = py + (Integer)Config.light_UpRange.get();
        this.overlayCache.clear();
        for (int xo = -((Integer)Config.light_HRange.get()).intValue(); xo <= (Integer)Config.light_HRange.get(); ++xo) {
            for (int zo = -((Integer)Config.light_HRange.get()).intValue(); zo <= (Integer)Config.light_HRange.get(); ++zo) {
                BlockPos pos1 = new BlockPos(px + xo, py, pz + zo);
                if (!this.shouldCheck(pos1, player.field_70170_p)) continue;
                for (int y = y1; y <= y2; ++y) {
                    BlockPos pos = new BlockPos(px + xo, y, pz + zo);
                    byte mode = this.getSpawnModeAt(pos, player.field_70170_p);
                    if (mode == 0) continue;
                    this.overlayCache.add((Pair<BlockPos, Byte>)Pair.of((Object)pos, (Object)mode));
                }
            }
        }
    }

    @Override
    public void clear() {
        this.overlayCache.clear();
    }

    @Override
    public List<Pair<BlockPos, Byte>> getLightModes() {
        return this.overlayCache;
    }

    public boolean shouldCheck(BlockPos pos, World world) {
        if (((Boolean)Config.light_IgnoreSpawnList.get()).booleanValue()) {
            return true;
        }
        Biome biome = world.func_226691_t_(pos);
        return biome.func_76741_f() > 0.0f && !biome.func_76747_a(EntityClassification.MONSTER).isEmpty();
    }

    public abstract byte getSpawnModeAt(BlockPos var1, World var2);
}

