/*
 * Decompiled with CFR 0.152.
 */
package at.feldim2425.moreoverlays.gui;

import at.feldim2425.moreoverlays.gui.config.ConfigOptionList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigScreen
extends Screen {
    private final String modId;
    private ForgeConfigSpec configSpec;
    private ConfigOptionList optionList;
    private String categoryTitle = null;
    private Button btnReset;
    private Button btnUndo;
    private Button btnBack;
    private List<String> pathCache = new ArrayList<String>();
    private String txtUndo = "";
    private String txtReset = "";
    private String txtDone = "";
    private Screen modListScreen;

    public ConfigScreen(Screen modListScreen, ForgeConfigSpec spec, String modId) {
        super((ITextComponent)new TranslationTextComponent("gui.config." + modId + ".tile", new Object[0]));
        this.modListScreen = modListScreen;
        this.configSpec = spec;
        this.modId = modId;
        this.txtReset = I18n.func_135052_a((String)"gui.config.moreoverlays.reset_config", (Object[])new Object[0]);
        this.txtUndo = I18n.func_135052_a((String)"gui.config.moreoverlays.undo", (Object[])new Object[0]);
        this.txtDone = I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]);
    }

    protected void init() {
        int pad;
        if (this.optionList == null) {
            this.optionList = new ConfigOptionList(this.minecraft, this.modId, this);
            if (this.pathCache.isEmpty()) {
                this.optionList.setConfiguration(this.configSpec);
            } else {
                this.optionList.setConfiguration(this.configSpec, this.pathCache);
            }
        }
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        int undoGlyphWidth = font.func_78256_a("\u21b6") * 2;
        int resetGlyphWidth = font.func_78256_a("\u2604") * 2;
        int undoWidth = font.func_78256_a(" " + this.txtUndo) + undoGlyphWidth + 20;
        int resetWidth = font.func_78256_a(" " + this.txtReset) + resetGlyphWidth + 20;
        int doneWidth = Math.max(font.func_78256_a(this.txtDone) + 20, 100);
        int buttonY = this.height - 32 + 6;
        int buttonHeight = 20;
        int xBack = pad = 10;
        int xDefaultAll = this.width - resetWidth - pad;
        int xUndoAll = xDefaultAll - undoWidth;
        this.btnReset = new Button(xDefaultAll, buttonY, 100, 20, "\u2604 " + this.txtReset, btn -> this.optionList.reset());
        this.btnUndo = new Button(xUndoAll, buttonY, 100, 20, "\u21b6 " + this.txtUndo, btn -> this.optionList.undo());
        this.btnBack = new Button(xBack, buttonY, doneWidth, 20, " " + this.txtDone, btn -> this.back());
        this.children.add(this.optionList);
        this.children.add(this.btnReset);
        this.children.add(this.btnUndo);
        this.children.add(this.btnBack);
        this.btnReset.active = false;
        this.btnUndo.active = false;
        this.optionList.updateGui();
    }

    private void back() {
        this.save();
        if (!this.optionList.getCurrentPath().isEmpty()) {
            this.optionList.pop();
        } else {
            Minecraft.func_71410_x().func_147108_a(this.modListScreen);
        }
    }

    public void render(int mouseX, int mouseY, float partialTick) {
        this.renderBackground();
        this.optionList.render(mouseX, mouseY, partialTick);
        this.btnReset.render(mouseX, mouseY, partialTick);
        this.btnUndo.render(mouseX, mouseY, partialTick);
        this.btnBack.render(mouseX, mouseY, partialTick);
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 8, 0xFFFFFF);
        if (this.categoryTitle != null) {
            this.drawCenteredString(this.font, this.categoryTitle, this.width / 2, 24, 0xFFFFFF);
        }
        super.render(mouseX, mouseY, partialTick);
    }

    private void save() {
        this.optionList.save();
        this.configSpec.save();
        this.optionList.undo();
    }

    public void tick() {
        super.tick();
        this.btnReset.active = this.optionList.isResettable();
        this.btnUndo.active = this.optionList.isUndoable();
    }

    public void updatePath(List<String> newPath) {
        String key = this.optionList.categoryTitleKey(newPath);
        this.categoryTitle = key == null ? null : I18n.func_135052_a((String)key, (Object[])new Object[0]);
        this.pathCache.clear();
        this.pathCache.addAll(newPath);
    }

    public boolean keyPressed(int key, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (key == 256) {
            this.back();
            return true;
        }
        return super.keyPressed(key, p_keyPressed_2_, p_keyPressed_3_);
    }
}

