/*
 * Decompiled with CFR 0.152.
 */
package at.feldim2425.moreoverlays.gui.config;

import at.feldim2425.moreoverlays.gui.config.ConfigOptionList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class OptionValueEntry<V>
extends ConfigOptionList.OptionEntry {
    public static final int CONTROL_WIDTH_NOVALIDATOR = 44;
    public static final int CONTROL_WIDTH_VALIDATOR = 64;
    public static final int TITLE_WIDTH = 80;
    private List<String> tooltip;
    private String txtUndo = "";
    private String txtReset = "";
    private String name = "";
    protected final ForgeConfigSpec.ConfigValue<V> value;
    protected final ForgeConfigSpec.ValueSpec spec;
    protected Button btnReset;
    protected Button btnUndo;
    protected V defaultValue;
    protected V newValue;
    protected boolean showValidity = false;
    private boolean valid = false;
    private boolean changes = false;

    public OptionValueEntry(ConfigOptionList list, ForgeConfigSpec.ConfigValue<V> confValue, ForgeConfigSpec.ValueSpec spec) {
        super(list);
        this.value = confValue;
        this.spec = spec;
        this.btnReset = new Button(list.getRowWidth() - 20, 0, 20, 20, "\u2604", btn -> this.reset());
        this.btnUndo = new Button(list.getRowWidth() - 42, 0, 20, 20, "\u21b6", btn -> this.undo());
        this.txtReset = I18n.func_135052_a((String)"gui.config.moreoverlays.reset_config", (Object[])new Object[0]);
        this.txtUndo = I18n.func_135052_a((String)"gui.config.moreoverlays.undo", (Object[])new Object[0]);
        Object defaultVal = this.spec.getDefault();
        if (defaultVal != null && spec.getClazz().isAssignableFrom(defaultVal.getClass())) {
            this.defaultValue = defaultVal;
        } else {
            this.btnReset.active = false;
        }
        this.name = (String)this.value.getPath().get(this.value.getPath().size() - 1);
        String[] lines = null;
        if (this.spec.getComment() != null) {
            lines = this.spec.getComment().split("\\n");
        }
        this.tooltip = new ArrayList<String>(lines.length + 1);
        this.tooltip.add(ChatFormatting.RED.toString() + this.name);
        for (String line : lines) {
            this.tooltip.add(ChatFormatting.YELLOW.toString() + line);
        }
        this.updateValue(this.value.get());
    }

    @Override
    protected void renderControls(int rowTop, int rowLeft, int rowWidth, int itemHeight, int mouseX, int mouseY, boolean mouseOver, float partialTick) {
        this.getConfigOptionList().getScreen().drawRightAlignedString(Minecraft.func_71410_x().field_71466_p, this.name, 80, 6, 0xFFFFFF);
        this.btnReset.render(mouseX, mouseY, partialTick);
        this.btnUndo.render(mouseX, mouseY, partialTick);
        if (this.showValidity) {
            if (this.valid) {
                this.getConfigOptionList().getScreen().drawCenteredString(Minecraft.func_71410_x().field_71466_p, "\u2714", this.getConfigOptionList().getRowWidth() - 53, 6, 65280);
            } else {
                this.getConfigOptionList().getScreen().drawCenteredString(Minecraft.func_71410_x().field_71466_p, "\u2715", this.getConfigOptionList().getRowWidth() - 53, 6, 0xFF0000);
            }
        }
    }

    @Override
    protected void renderTooltip(int rowTop, int rowLeft, int rowWidth, int itemHeight, int mouseX, int mouseY) {
        super.renderTooltip(rowTop, rowLeft, rowWidth, itemHeight, mouseX, mouseY);
        if (this.btnReset.isHovered()) {
            this.getConfigOptionList().getScreen().renderTooltip(this.txtReset, mouseX, mouseY);
        } else if (this.btnUndo.isHovered()) {
            this.getConfigOptionList().getScreen().renderTooltip(this.txtUndo, mouseX, mouseY);
        } else if (mouseX < 80 + rowLeft) {
            this.getConfigOptionList().getScreen().renderTooltip(this.tooltip, mouseX, mouseY);
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_227722_g_();
    }

    protected abstract void overrideUnsaved(V var1);

    protected boolean isUndoable(V current) {
        return current == null || !current.equals(this.value.get()) || !this.valid;
    }

    protected void updateValue(@Nullable V value) {
        this.valid = value != null && this.spec.test(value);
        this.btnReset.active = this.isResettable();
        this.btnUndo.active = this.changes = this.isUndoable(value);
        this.newValue = value;
    }

    @Override
    public void undo() {
        this.overrideUnsaved(this.value.get());
        this.updateValue(this.value.get());
    }

    @Override
    public void reset() {
        if (this.defaultValue != null) {
            this.value.set(this.defaultValue);
            this.overrideUnsaved(this.defaultValue);
            this.updateValue(this.defaultValue);
        }
    }

    @Override
    public List<? extends IGuiEventListener> children() {
        return Arrays.asList(this.btnReset, this.btnUndo);
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public boolean hasChanges() {
        return this.changes;
    }

    @Override
    public boolean isResettable() {
        return this.defaultValue != null && (this.value.get() == null || !this.value.get().equals(this.defaultValue));
    }

    @Override
    public void save() {
        this.value.set(this.newValue);
        this.value.save();
    }
}

