/*
 * Decompiled with CFR 0.152.
 */
package at.feldim2425.moreoverlays.lightoverlay;

import at.feldim2425.moreoverlays.api.lightoverlay.LightScannerBase;
import at.feldim2425.moreoverlays.config.Config;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class LightScannerVanilla
extends LightScannerBase {
    private static final AxisAlignedBB TEST_BB = new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 1.0, 0.7);
    private List<EntityType<?>> typesToCheck = ForgeRegistries.ENTITIES.getValues().stream().filter(type -> type.func_200720_b() && type.func_220339_d() == EntityClassification.MONSTER).collect(Collectors.toList());

    @Override
    public byte getSpawnModeAt(BlockPos pos, World world) {
        if (world.func_226658_a_(LightType.BLOCK, pos) >= (Integer)Config.light_SaveLevel.get()) {
            return 0;
        }
        BlockPos blockPos = pos.func_177977_b();
        if (world.func_175623_d(blockPos)) {
            return 0;
        }
        if (!LightScannerVanilla.checkCollision(pos, world)) {
            return 0;
        }
        BlockState state = world.func_180495_p(blockPos);
        Block block = state.func_177230_c();
        if (!((Boolean)Config.light_SimpleEntityCheck.get()).booleanValue()) {
            boolean hasSpawnable = false;
            for (EntityType<?> type : this.typesToCheck) {
                if (!block.canCreatureSpawn(state, (IBlockReader)world, blockPos, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, type)) continue;
                hasSpawnable = true;
                break;
            }
            if (!hasSpawnable) {
                return 0;
            }
        } else if (!block.canCreatureSpawn(state, (IBlockReader)world, blockPos, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, EntityType.field_200725_aD)) {
            return 0;
        }
        if (world.func_226658_a_(LightType.SKY, pos) >= (Integer)Config.light_SaveLevel.get()) {
            return 1;
        }
        return 2;
    }

    private static boolean checkCollision(BlockPos pos, World world) {
        BlockState block1 = world.func_180495_p(pos);
        if (block1.func_215686_e((IBlockReader)world, pos) || !((Boolean)Config.light_IgnoreLayer.get()).booleanValue() && world.func_180495_p(pos.func_177984_a()).func_215686_e((IBlockReader)world, pos.func_177984_a())) {
            return false;
        }
        if (world.func_175623_d(pos) && (((Boolean)Config.light_IgnoreLayer.get()).booleanValue() || world.func_175623_d(pos.func_177984_a()))) {
            return true;
        }
        AxisAlignedBB bb = TEST_BB.func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        if (world.func_226666_b_(null, bb).count() == 0L && !world.func_72953_d(bb)) {
            if (((Boolean)Config.light_IgnoreLayer.get()).booleanValue()) {
                return true;
            }
            AxisAlignedBB bb2 = bb.func_72317_d(0.0, 1.0, 0.0);
            return world.func_226666_b_(null, bb2).count() == 0L && !world.func_72953_d(bb2);
        }
        return false;
    }
}

