/*
 * Decompiled with CFR 0.152.
 */
package at.feldim2425.moreoverlays.api.lightoverlay;

import at.feldim2425.moreoverlays.api.lightoverlay.ILightScanner;
import at.feldim2425.moreoverlays.config.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import org.apache.commons.lang3.tuple.Pair;

public abstract class LightScannerBase
implements ILightScanner {
    protected List<Pair<BlockPos, Byte>> overlayCache = new ArrayList<Pair<BlockPos, Byte>>();

    @Override
    public void update(PlayerEntity player) {
        int px = (int)Math.floor(player.func_226277_ct_());
        int py = (int)Math.floor(player.func_226278_cu_());
        int pz = (int)Math.floor(player.func_226281_cx_());
        int y1 = py - (Integer)Config.light_DownRange.get();
        int y2 = py + (Integer)Config.light_UpRange.get();
        int HRange = (Integer)Config.light_HRange.get();
        this.overlayCache.clear();
        int HRangeNorth = HRange;
        int HRangeEast = HRange;
        int HRangeSouth = HRange;
        int HRangeWest = HRange;
        if (HRange > 5 && player.func_70040_Z().field_72448_b > -0.5 && player.func_70040_Z().field_72448_b < 0.5) {
            switch (player.func_174811_aO()) {
                case NORTH: {
                    HRangeSouth = 5;
                    break;
                }
                case EAST: {
                    HRangeWest = 5;
                    break;
                }
                case SOUTH: {
                    HRangeNorth = 5;
                    break;
                }
                case WEST: {
                    HRangeEast = 5;
                }
            }
        }
        for (int xo = -HRangeWest; xo <= HRangeEast; ++xo) {
            for (int zo = -HRangeNorth; zo <= HRangeSouth; ++zo) {
                BlockPos pos1 = new BlockPos(px + xo, py, pz + zo);
                if (!this.shouldCheck(pos1, player.field_70170_p)) continue;
                for (int y = y1; y <= y2; ++y) {
                    BlockPos pos = new BlockPos(px + xo, y, pz + zo);
                    byte mode = this.getSpawnModeAt(pos, player.field_70170_p);
                    if (mode == 0) continue;
                    this.overlayCache.add((Pair<BlockPos, Byte>)Pair.of((Object)pos, (Object)mode));
                }
            }
        }
    }

    @Override
    public void clear() {
        this.overlayCache.clear();
    }

    @Override
    public List<Pair<BlockPos, Byte>> getLightModes() {
        return this.overlayCache;
    }

    public boolean shouldCheck(BlockPos pos, World world) {
        if (world.field_72995_K) {
            return true;
        }
        if (((Boolean)Config.light_IgnoreSpawnList.get()).booleanValue()) {
            return true;
        }
        Biome biome = world.func_226691_t_(pos);
        return biome.func_242433_b().func_242557_a() > 0.0f && !biome.func_242433_b().func_242559_a(EntityClassification.MONSTER).isEmpty();
    }

    public abstract byte getSpawnModeAt(BlockPos var1, World var2);
}

