/*
 * Decompiled with CFR 0.152.
 */
package at.feldim2425.moreoverlays.gui;

import at.feldim2425.moreoverlays.gui.config.ConfigOptionList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigScreen
extends Screen {
    private final String modId;
    private final ForgeConfigSpec configSpec;
    private final List<String> pathCache = new ArrayList<String>();
    private final Screen modListScreen;
    private ConfigOptionList optionList;
    private String categoryTitle = null;
    private Button btnReset;
    private Button btnUndo;
    private Button btnBack;
    private String txtUndo = "";
    private String txtReset = "";
    private String txtDone = "";

    public ConfigScreen(Screen modListScreen, ForgeConfigSpec spec, String modId) {
        super((ITextComponent)new TranslationTextComponent("gui.config." + modId + ".tile"));
        this.modListScreen = modListScreen;
        this.configSpec = spec;
        this.modId = modId;
        this.txtReset = I18n.func_135052_a((String)"gui.config.moreoverlays.reset_config", (Object[])new Object[0]);
        this.txtUndo = I18n.func_135052_a((String)"gui.config.moreoverlays.undo", (Object[])new Object[0]);
        this.txtDone = I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]);
    }

    protected void func_231160_c_() {
        int pad;
        if (this.optionList == null) {
            this.optionList = new ConfigOptionList(this.field_230706_i_, this.modId, this);
            if (this.pathCache.isEmpty()) {
                this.optionList.setConfiguration(this.configSpec);
            } else {
                this.optionList.setConfiguration(this.configSpec, this.pathCache);
            }
        }
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        int undoGlyphWidth = font.func_78256_a("\u21b6") * 2;
        int resetGlyphWidth = font.func_78256_a("\u2604") * 2;
        int undoWidth = font.func_78256_a(" " + this.txtUndo) + undoGlyphWidth + 20;
        int resetWidth = font.func_78256_a(" " + this.txtReset) + resetGlyphWidth + 20;
        int doneWidth = Math.max(font.func_78256_a(this.txtDone) + 20, 100);
        int buttonY = this.field_230709_l_ - 32 + 6;
        int buttonHeight = 20;
        int xBack = pad = 10;
        int xDefaultAll = this.field_230708_k_ - resetWidth - pad;
        int xUndoAll = xDefaultAll - undoWidth;
        this.btnReset = new Button(xDefaultAll, buttonY, 100, 20, ITextComponent.func_244388_a((String)("\u2604 " + this.txtReset)), btn -> this.optionList.reset());
        this.btnUndo = new Button(xUndoAll, buttonY, 100, 20, ITextComponent.func_244388_a((String)("\u21b6 " + this.txtUndo)), btn -> this.optionList.undo());
        this.btnBack = new Button(xBack, buttonY, doneWidth, 20, ITextComponent.func_244388_a((String)(" " + this.txtDone)), btn -> this.back());
        this.field_230705_e_.add(this.optionList);
        this.field_230705_e_.add(this.btnReset);
        this.field_230705_e_.add(this.btnUndo);
        this.field_230705_e_.add(this.btnBack);
        this.btnReset.field_230693_o_ = false;
        this.btnUndo.field_230693_o_ = false;
        this.optionList.updateGui();
    }

    private void back() {
        this.save();
        if (!this.optionList.getCurrentPath().isEmpty()) {
            this.optionList.pop();
        } else {
            Minecraft.func_71410_x().func_147108_a(this.modListScreen);
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        this.optionList.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.btnReset.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.btnUndo.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.btnBack.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        ConfigScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.func_231171_q_(), (int)(this.field_230708_k_ / 2), (int)8, (int)0xFFFFFF);
        if (this.categoryTitle != null) {
            ConfigScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)this.categoryTitle, (int)(this.field_230708_k_ / 2), (int)24, (int)0xFFFFFF);
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    private void save() {
        this.optionList.save();
        this.configSpec.save();
        this.optionList.undo();
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.btnReset.field_230693_o_ = this.optionList.isResettable();
        this.btnUndo.field_230693_o_ = this.optionList.isUndoable();
    }

    public void updatePath(List<String> newPath) {
        String key = this.optionList.categoryTitleKey(newPath);
        this.categoryTitle = key == null ? null : I18n.func_135052_a((String)key, (Object[])new Object[0]);
        this.pathCache.clear();
        this.pathCache.addAll(newPath);
    }

    public boolean func_231046_a_(int key, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (key == 256) {
            this.back();
            return true;
        }
        return super.func_231046_a_(key, p_keyPressed_2_, p_keyPressed_3_);
    }
}

