/*
 * Decompiled with CFR 0.152.
 */
package at.feldim2425.moreoverlays.gui.config;

import at.feldim2425.moreoverlays.MoreOverlays;
import at.feldim2425.moreoverlays.gui.ConfigScreen;
import at.feldim2425.moreoverlays.gui.config.OptionBoolean;
import at.feldim2425.moreoverlays.gui.config.OptionCategory;
import at.feldim2425.moreoverlays.gui.config.OptionGeneric;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.INestedGuiEventHandler;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigOptionList
extends AbstractOptionList<OptionEntry> {
    public static final String UNDO_CHAR = "\u21b6";
    public static final String RESET_CHAR = "\u2604";
    public static final String VALID = "\u2714";
    public static final String INVALID = "\u2715";
    private static final int ITEM_HEIGHT = 22;
    private final ConfigScreen parent;
    private final String modId;
    private ForgeConfigSpec rootConfig;
    private List<String> configPath = Collections.emptyList();
    private Map<String, Object> currentMap;
    private CommentedConfig comments;

    public ConfigOptionList(Minecraft minecraft, String modId, ConfigScreen configs) {
        super(minecraft, configs.field_230708_k_, configs.field_230709_l_, 43, configs.field_230709_l_ - 32, 22);
        this.parent = configs;
        this.modId = modId;
    }

    public static List<String> splitPath(String path) {
        return Arrays.asList(path.split("\\."));
    }

    public ConfigScreen getScreen() {
        return this.parent;
    }

    protected int func_230952_d_() {
        return super.func_230952_d_() + 15 + 20;
    }

    public int func_230949_c_() {
        return super.func_230949_c_() + 64;
    }

    public void updateGui() {
        this.func_230940_a_(this.parent.field_230708_k_, this.parent.field_230709_l_, 43, this.parent.field_230709_l_ - 32);
    }

    protected void func_230447_a_(MatrixStack matrixStack, int p_renderDecorations_1_, int p_renderDecorations_2_) {
        int i = this.func_230965_k_();
        for (int j = 0; j < i; ++j) {
            int k = this.func_230962_i_(j);
            int l = this.func_230962_i_(j) + 22;
            if (l < this.field_230672_i_ || k > this.field_230673_j_) continue;
            OptionEntry e = (OptionEntry)this.func_230953_d_(j);
            e.runRenderTooltip(matrixStack);
        }
    }

    public String categoryTitleKey(List<String> path) {
        if (path.isEmpty()) {
            return null;
        }
        return "config." + this.modId + ".category." + path.stream().collect(Collectors.joining("."));
    }

    public void setConfiguration(ForgeConfigSpec rootConfig) {
        this.setConfiguration(rootConfig, Collections.emptyList());
    }

    public void setConfiguration(ForgeConfigSpec rootConfig, List<String> path) {
        this.rootConfig = rootConfig;
        try {
            Field forgeconfigspec_childconfig = ForgeConfigSpec.class.getDeclaredField("childConfig");
            forgeconfigspec_childconfig.setAccessible(true);
            Object childConfig_raw = forgeconfigspec_childconfig.get(rootConfig);
            if (childConfig_raw instanceof CommentedConfig) {
                this.comments = (CommentedConfig)childConfig_raw;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            MoreOverlays.logger.warn("Couldn't reflect childConfig from ForgeConfigSpec! Comments will be missing.", (Throwable)e);
        }
        this.updatePath(path);
    }

    private void setPath(List<String> path) {
        Object val = path.isEmpty() ? this.rootConfig.getValues() : this.rootConfig.getValues().getRaw(path);
        if (!(val instanceof UnmodifiableConfig)) {
            int n = path.size();
            if (n > 1 && path.get(n - 1) == path.get(n - 2)) {
                MoreOverlays.logger.error("Attempting to load duplicate path:", path);
                MoreOverlays.logger.warn("This could be caused by key event race condition");
                path.remove(n - 1);
                this.setPath(path);
                return;
            }
            throw new IllegalArgumentException("Path in config list has to point to another config object");
        }
        this.configPath = path;
        this.currentMap = val.valueMap();
        this.refreshEntries();
        this.parent.updatePath(this.getCurrentPath());
    }

    public void updatePath(List<String> path) {
        this.setPath(new ArrayList<String>(path));
    }

    public void push(String path) {
        this.push(ConfigOptionList.splitPath(path));
    }

    public void push(List<String> path) {
        ArrayList<String> tmp = new ArrayList<String>(this.configPath.size() + path.size());
        tmp.addAll(this.configPath);
        tmp.addAll(path);
        this.setPath(tmp);
    }

    public void pop() {
        this.pop(1);
    }

    public void pop(int amount) {
        ArrayList<String> tmp = new ArrayList<String>(this.configPath);
        for (int i = 0; i < amount && !tmp.isEmpty(); ++i) {
            tmp.remove(tmp.size() - 1);
        }
        this.setPath(tmp);
    }

    public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        boolean flag = super.func_231044_a_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        OptionEntry selected = (OptionEntry)this.func_230933_a_(p_mouseClicked_1_, p_mouseClicked_3_);
        for (OptionEntry entry : this.func_231039_at__()) {
            if (entry == selected || !entry.func_231049_c__(true)) continue;
            entry.func_231049_c__(true);
        }
        return flag;
    }

    public void refreshEntries() {
        this.func_230963_j_();
        for (Map.Entry<String, Object> cEntry : this.currentMap.entrySet()) {
            ArrayList<String> fullPath = new ArrayList<String>(this.configPath.size() + 1);
            fullPath.addAll(this.configPath);
            fullPath.add(cEntry.getKey());
            String comment = null;
            if (this.comments != null) {
                comment = this.comments.getComment(fullPath);
            }
            if (cEntry.getValue() instanceof UnmodifiableConfig) {
                String name = I18n.func_135052_a((String)this.categoryTitleKey(fullPath), (Object[])new Object[0]);
                this.func_230513_b_((AbstractList.AbstractListEntry)new OptionCategory(this, Arrays.asList(cEntry.getKey()), name, comment));
                continue;
            }
            if (cEntry.getValue() instanceof ForgeConfigSpec.BooleanValue) {
                this.func_230513_b_((AbstractList.AbstractListEntry)new OptionBoolean(this, (ForgeConfigSpec.BooleanValue)cEntry.getValue(), (ForgeConfigSpec.ValueSpec)this.rootConfig.getSpec().get(fullPath)));
                continue;
            }
            this.func_230513_b_((AbstractList.AbstractListEntry)new OptionGeneric(this, (ForgeConfigSpec.ConfigValue)cEntry.getValue(), (ForgeConfigSpec.ValueSpec)this.rootConfig.getSpec().get(fullPath)));
        }
        if (this.func_231049_c__(true)) {
            this.func_231049_c__(true);
        }
    }

    public List<String> getCurrentPath() {
        return Collections.unmodifiableList(this.configPath);
    }

    public ForgeConfigSpec getConfig() {
        return this.rootConfig;
    }

    public String getModId() {
        return this.modId;
    }

    public boolean isSaveable() {
        boolean hasChanges = false;
        for (OptionEntry entry : this.func_231039_at__()) {
            if (!entry.isValid()) {
                return false;
            }
            hasChanges = hasChanges || entry.hasChanges();
        }
        return hasChanges;
    }

    public boolean isResettable() {
        boolean resettable = false;
        for (OptionEntry entry : this.func_231039_at__()) {
            resettable = resettable || entry.isResettable();
        }
        return resettable;
    }

    public boolean isUndoable() {
        boolean hasChanges = false;
        for (OptionEntry entry : this.func_231039_at__()) {
            hasChanges = hasChanges || entry.hasChanges();
        }
        return hasChanges;
    }

    public void reset() {
        for (OptionEntry entry : this.func_231039_at__()) {
            entry.reset();
        }
    }

    public void undo() {
        for (OptionEntry entry : this.func_231039_at__()) {
            entry.undo();
        }
    }

    public void save() {
        for (OptionEntry entry : this.func_231039_at__()) {
            if (!entry.isValid()) continue;
            entry.save();
        }
    }

    public static abstract class OptionEntry
    extends AbstractOptionList.Entry<OptionEntry>
    implements INestedGuiEventHandler {
        private final ConfigOptionList optionList;
        protected int rowTop;
        protected int rowLeft;
        private int rowWidth;
        private int itemHeight;
        private int mouseX;
        private int mouseY;
        private boolean mouseOver;

        public OptionEntry(ConfigOptionList list) {
            this.optionList = list;
        }

        public void func_230432_a_(MatrixStack matrixStack, int itemindex, int rowTop, int rowLeft, int rowWidth, int itemHeight, int mouseX, int mouseY, boolean mouseOver, float partialTick) {
            this.rowTop = rowTop;
            this.rowLeft = rowLeft;
            this.rowWidth = rowWidth;
            this.itemHeight = itemHeight;
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            this.mouseOver = mouseOver;
            GlStateManager.func_227688_c_((float)rowLeft, (float)rowTop, (float)0.0f);
            this.renderControls(matrixStack, rowTop, rowLeft, rowWidth, itemHeight, mouseX -= rowLeft, mouseY -= rowTop, mouseOver, partialTick);
            GlStateManager.func_227688_c_((float)(-rowLeft), (float)(-rowTop), (float)0.0f);
        }

        protected abstract void renderControls(MatrixStack var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9);

        public void runRenderTooltip(MatrixStack matrixStack) {
            if (this.mouseOver) {
                this.renderTooltip(matrixStack, this.rowTop, this.rowLeft, this.rowWidth, this.itemHeight, this.mouseX, this.mouseY);
                RenderHelper.func_74518_a();
                GlStateManager.func_227722_g_();
            }
        }

        protected void renderTooltip(MatrixStack matrixStack, int rowTop, int rowLeft, int rowWidth, int itemHeight, int mouseX, int mouseY) {
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return Collections.emptyList();
        }

        public ConfigOptionList getConfigOptionList() {
            return this.optionList;
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            return super.func_231044_a_(mouseX - (double)this.rowLeft, mouseY - (double)this.rowTop, button);
        }

        public boolean func_231048_c_(double mouseX, double mouseY, int button) {
            return super.func_231048_c_(mouseX - (double)this.rowLeft, mouseY - (double)this.rowTop, button);
        }

        public boolean func_231045_a_(double fromX, double fromY, int button, double toX, double toY) {
            return super.func_231045_a_(fromX - (double)this.rowLeft, fromY - (double)this.rowTop, button, toX - (double)this.rowLeft, toY - (double)this.rowTop);
        }

        public boolean func_231041_ay__() {
            return false;
        }

        public void func_231037_b__(boolean dragging) {
        }

        public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
            return super.func_231043_a_(mouseX - (double)this.rowLeft, mouseY - (double)this.rowTop, amount);
        }

        public boolean isValid() {
            return true;
        }

        public boolean hasChanges() {
            return false;
        }

        public boolean isResettable() {
            return false;
        }

        public void reset() {
        }

        public void undo() {
        }

        public void save() {
        }
    }
}

