/*
 * Decompiled with CFR 0.152.
 */
package at.feldim2425.moreoverlays.gui.config;

import at.feldim2425.moreoverlays.gui.config.ConfigOptionList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class OptionValueEntry<V>
extends ConfigOptionList.OptionEntry {
    public static final int CONTROL_WIDTH_NOVALIDATOR = 44;
    public static final int CONTROL_WIDTH_VALIDATOR = 64;
    public static final int TITLE_WIDTH = 80;
    protected final ForgeConfigSpec.ConfigValue<V> value;
    protected final ForgeConfigSpec.ValueSpec spec;
    private final List<String> tooltip;
    protected Button btnReset;
    protected Button btnUndo;
    protected V defaultValue;
    protected V newValue;
    protected boolean showValidity = false;
    private String txtUndo = "";
    private String txtReset = "";
    private String name = "";
    private boolean valid = false;
    private boolean changes = false;

    public OptionValueEntry(ConfigOptionList list, ForgeConfigSpec.ConfigValue<V> confValue, ForgeConfigSpec.ValueSpec spec) {
        super(list);
        this.value = confValue;
        this.spec = spec;
        this.btnReset = new Button(list.func_230949_c_() - 20, 0, 20, 20, ITextComponent.func_244388_a((String)"\u2604"), btn -> this.reset());
        this.btnUndo = new Button(list.func_230949_c_() - 42, 0, 20, 20, ITextComponent.func_244388_a((String)"\u21b6"), btn -> this.undo());
        this.txtReset = I18n.func_135052_a((String)"gui.config.moreoverlays.reset_config", (Object[])new Object[0]);
        this.txtUndo = I18n.func_135052_a((String)"gui.config.moreoverlays.undo", (Object[])new Object[0]);
        Object defaultVal = this.spec.getDefault();
        if (defaultVal != null && spec.getClazz().isAssignableFrom(defaultVal.getClass())) {
            this.defaultValue = defaultVal;
        } else {
            this.btnReset.field_230693_o_ = false;
        }
        this.name = (String)this.value.getPath().get(this.value.getPath().size() - 1);
        String[] lines = null;
        if (this.spec.getComment() != null) {
            lines = this.spec.getComment().split("\\n");
            this.tooltip = new ArrayList<String>(lines.length + 1);
        } else {
            this.tooltip = new ArrayList<String>(1);
        }
        this.tooltip.add(TextFormatting.RED + this.name);
        for (String line : lines) {
            this.tooltip.add(TextFormatting.YELLOW + line);
        }
        this.updateValue(this.value.get());
    }

    @Override
    protected void renderControls(MatrixStack matrixStack, int rowTop, int rowLeft, int rowWidth, int itemHeight, int mouseX, int mouseY, boolean mouseOver, float partialTick) {
        AbstractGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)this.name, (int)-20, (int)6, (int)0xFFFFFF);
        this.btnReset.func_230430_a_(matrixStack, mouseX, mouseY, partialTick);
        this.btnUndo.func_230430_a_(matrixStack, mouseX, mouseY, partialTick);
        if (this.showValidity) {
            if (this.valid) {
                AbstractGui.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)"\u2714", (int)(this.getConfigOptionList().func_230949_c_() - 53), (int)6, (int)65280);
            } else {
                AbstractGui.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)"\u2715", (int)(this.getConfigOptionList().func_230949_c_() - 53), (int)6, (int)0xFF0000);
            }
        }
    }

    @Override
    protected void renderTooltip(MatrixStack matrixStack, int rowTop, int rowLeft, int rowWidth, int itemHeight, int mouseX, int mouseY) {
        super.renderTooltip(matrixStack, rowTop, rowLeft, rowWidth, itemHeight, mouseX, mouseY);
        ArrayList<ITextComponent> tooltipConverted = new ArrayList<ITextComponent>();
        for (String iTextComponent : this.tooltip) {
            tooltipConverted.add(ITextComponent.func_244388_a((String)iTextComponent));
        }
        if (this.btnReset.func_230449_g_()) {
            this.getConfigOptionList().getScreen().func_238652_a_(matrixStack, ITextComponent.func_244388_a((String)this.txtReset), mouseX, mouseY);
        } else if (this.btnUndo.func_230449_g_()) {
            this.getConfigOptionList().getScreen().func_238652_a_(matrixStack, ITextComponent.func_244388_a((String)this.txtUndo), mouseX, mouseY);
        } else if (mouseX < 80 + rowLeft) {
            this.getConfigOptionList().getScreen().func_243308_b(matrixStack, tooltipConverted, mouseX, mouseY);
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_227722_g_();
    }

    protected abstract void overrideUnsaved(V var1);

    protected boolean isUndoable(V current) {
        return current == null || !current.equals(this.value.get()) || !this.valid;
    }

    protected void updateValue(@Nullable V value) {
        this.valid = value != null && this.spec.test(value);
        this.btnReset.field_230693_o_ = this.isResettable();
        this.btnUndo.field_230693_o_ = this.changes = this.isUndoable(value);
        this.newValue = value;
    }

    @Override
    public void undo() {
        this.overrideUnsaved(this.value.get());
        this.updateValue(this.value.get());
    }

    @Override
    public void reset() {
        if (this.defaultValue != null) {
            this.value.set(this.defaultValue);
            this.overrideUnsaved(this.defaultValue);
            this.updateValue(this.defaultValue);
        }
    }

    @Override
    public List<? extends IGuiEventListener> func_231039_at__() {
        return Arrays.asList(this.btnReset, this.btnUndo);
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public boolean hasChanges() {
        return this.changes;
    }

    @Override
    public boolean isResettable() {
        return this.defaultValue != null && (this.value.get() == null || !this.value.get().equals(this.defaultValue));
    }

    @Override
    public void save() {
        this.value.set(this.newValue);
        this.value.save();
    }
}

