/*
 * Decompiled with CFR 0.152.
 */
package at.feldim2425.moreoverlays.itemsearch;

import at.feldim2425.moreoverlays.api.itemsearch.SlotHandler;
import at.feldim2425.moreoverlays.api.itemsearch.SlotViewWrapper;
import at.feldim2425.moreoverlays.config.Config;
import at.feldim2425.moreoverlays.itemsearch.GuiUtils;
import at.feldim2425.moreoverlays.itemsearch.ItemUtils;
import at.feldim2425.moreoverlays.itemsearch.JeiModule;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector2f;

public class GuiRenderer {
    public static final GuiRenderer INSTANCE = new GuiRenderer();
    private static final float OVERLAY_ZLEVEL = 299.0f;
    private static final float FRAME_RADIUS = 1.0f;
    private static boolean enabled = false;
    private static String lastFilterText = "";
    private static boolean emptyFilter = true;
    private static BiMap<Slot, SlotViewWrapper> views = HashBiMap.create();
    private boolean allowRender = false;
    private int guiOffsetX = 0;
    private int guiOffsetY = 0;

    public void guiInit(Screen gui) {
        if (!this.canShowIn(gui)) {
            return;
        }
        this.guiOffsetX = GuiUtils.getGuiLeft((ContainerScreen)gui);
        this.guiOffsetY = GuiUtils.getGuiTop((ContainerScreen)gui);
    }

    public void guiOpen(Screen gui) {
    }

    public void preDraw() {
        Screen guiscr = Minecraft.func_71410_x().field_71462_r;
        TextFieldWidget textField = JeiModule.getJEITextField();
        if (this.canShowIn(guiscr)) {
            this.allowRender = true;
            if (textField != null && enabled) {
                this.drawSearchFrame(textField);
            }
        }
    }

    public void postDraw() {
        Screen guiscr = Minecraft.func_71410_x().field_71462_r;
        if (this.allowRender && this.canShowIn(guiscr)) {
            this.allowRender = false;
            this.drawSlotOverlay((ContainerScreen)guiscr);
        }
    }

    private void drawSearchFrame(TextFieldWidget textField) {
        RenderHelper.func_74518_a();
        GlStateManager.func_227709_e_();
        GlStateManager.func_227734_k_();
        GlStateManager.func_227621_I_();
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_227626_N_();
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buffer = tess.func_178180_c();
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        float x = textField.field_230690_l_ + 2;
        float y = textField.field_230691_m_ + 2;
        float width = textField.func_230998_h_() - 4;
        float height = textField.func_238483_d_() - 4;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_225582_a_((double)(x + width + 1.0f), (double)(y - 1.0f), 1000.0).func_181675_d();
        buffer.func_225582_a_((double)(x - 1.0f), (double)(y - 1.0f), 1000.0).func_181675_d();
        buffer.func_225582_a_((double)(x - 1.0f), (double)y, 1000.0).func_181675_d();
        buffer.func_225582_a_((double)(x + width + 1.0f), (double)y, 1000.0).func_181675_d();
        buffer.func_225582_a_((double)x, (double)y, 1000.0).func_181675_d();
        buffer.func_225582_a_((double)(x - 1.0f), (double)y, 1000.0).func_181675_d();
        buffer.func_225582_a_((double)(x - 1.0f), (double)(y + height), 1000.0).func_181675_d();
        buffer.func_225582_a_((double)x, (double)(y + height), 1000.0).func_181675_d();
        buffer.func_225582_a_((double)(x + width + 1.0f), (double)(y + height), 1000.0).func_181675_d();
        buffer.func_225582_a_((double)(x - 1.0f), (double)(y + height), 1000.0).func_181675_d();
        buffer.func_225582_a_((double)(x - 1.0f), (double)(y + height + 1.0f), 1000.0).func_181675_d();
        buffer.func_225582_a_((double)(x + width + 1.0f), (double)(y + height + 1.0f), 1000.0).func_181675_d();
        buffer.func_225582_a_((double)(x + width + 1.0f), (double)y, 1000.0).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)y, 1000.0).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)(y + height), 1000.0).func_181675_d();
        buffer.func_225582_a_((double)(x + width + 1.0f), (double)(y + height), 1000.0).func_181675_d();
        tess.func_78381_a();
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_227737_l_();
        GlStateManager.func_227627_O_();
        GlStateManager.func_227619_H_();
    }

    public void renderTooltip(ItemStack stack) {
        ContainerScreen gui;
        Screen guiscr = Minecraft.func_71410_x().field_71462_r;
        if (this.allowRender && this.canShowIn(guiscr) && (gui = (ContainerScreen)guiscr).getSlotUnderMouse() != null && gui.getSlotUnderMouse().func_75216_d() && gui.getSlotUnderMouse().func_75211_c().equals(stack)) {
            this.allowRender = false;
            this.drawSlotOverlay((ContainerScreen)guiscr);
        }
    }

    private void drawSlotOverlay(ContainerScreen<?> gui) {
        RenderHelper.func_74518_a();
        GlStateManager.func_227709_e_();
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!enabled || views == null || views.isEmpty()) {
            return;
        }
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder renderer = tess.func_178180_c();
        GlStateManager.func_227626_N_();
        GlStateManager.func_227740_m_();
        GlStateManager.func_227621_I_();
        GlStateManager.func_227702_d_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
        renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (Map.Entry slot : views.entrySet()) {
            if (!((SlotViewWrapper)slot.getValue()).isEnableOverlay()) continue;
            Vector2f posvec = ((SlotViewWrapper)slot.getValue()).getView().getRenderPos(this.guiOffsetX, this.guiOffsetY);
            float px = posvec.field_189982_i;
            float py = posvec.field_189983_j;
            renderer.func_225582_a_((double)(px + 16.0f + (float)this.guiOffsetX), (double)(py + (float)this.guiOffsetY), 299.0).func_181675_d();
            renderer.func_225582_a_((double)(px + (float)this.guiOffsetX), (double)(py + (float)this.guiOffsetY), 299.0).func_181675_d();
            renderer.func_225582_a_((double)(px + (float)this.guiOffsetX), (double)(py + 16.0f + (float)this.guiOffsetY), 299.0).func_181675_d();
            renderer.func_225582_a_((double)(px + 16.0f + (float)this.guiOffsetX), (double)(py + 16.0f + (float)this.guiOffsetY), 299.0).func_181675_d();
        }
        tess.func_78381_a();
        GlStateManager.func_227619_H_();
        GlStateManager.func_227627_O_();
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_227737_l_();
    }

    public boolean canShowIn(Screen gui) {
        return gui instanceof ContainerScreen && ((ContainerScreen)gui).func_212873_a_() != null && !((ContainerScreen)gui).func_212873_a_().field_75151_b.isEmpty();
    }

    private void checkSlots(ContainerScreen<?> container) {
        if (views == null) {
            views = HashBiMap.create();
        } else {
            views.clear();
        }
        for (Slot slot : container.func_212873_a_().field_75151_b) {
            SlotViewWrapper wrapper;
            if (!views.containsKey((Object)slot)) {
                wrapper = new SlotViewWrapper(SlotHandler.INSTANCE.getViewSlot(container, slot));
                views.put((Object)slot, (Object)wrapper);
            } else {
                wrapper = (SlotViewWrapper)views.get((Object)slot);
            }
            wrapper.setEnableOverlay(wrapper.getView().canSearch() && !this.isSearchedItem(slot.func_75211_c()));
        }
    }

    private boolean isSearchedItem(ItemStack stack) {
        if (emptyFilter) {
            return true;
        }
        if (stack.func_190926_b()) {
            return false;
        }
        for (Object ingredient : JeiModule.filter.getFilteredIngredients()) {
            if (!ItemUtils.ingredientMatches(ingredient, stack)) continue;
            return true;
        }
        return (Boolean)Config.search_searchCustom.get() != false && stack.func_200301_q().getString().toLowerCase().contains(JeiModule.getJEITextField().func_146179_b().toLowerCase());
    }

    public void tick() {
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (!this.canShowIn(screen)) {
            return;
        }
        if (enabled && !JeiModule.filter.getFilterText().equals(lastFilterText)) {
            lastFilterText = JeiModule.filter.getFilterText();
            emptyFilter = lastFilterText.replace(" ", "").isEmpty();
        }
        if (enabled && screen instanceof ContainerScreen) {
            this.checkSlots((ContainerScreen)screen);
            this.guiOffsetX = GuiUtils.getGuiLeft((ContainerScreen)screen);
            this.guiOffsetY = GuiUtils.getGuiTop((ContainerScreen)screen);
        } else if (views != null) {
            views.clear();
        }
    }

    public void toggleMode() {
        boolean bl = enabled = !enabled;
        if (enabled) {
            lastFilterText = JeiModule.filter.getFilterText();
            emptyFilter = lastFilterText.replace(" ", "").isEmpty();
        } else {
            lastFilterText = "";
        }
    }

    public boolean isEnabled() {
        return enabled;
    }
}

