/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.chunkbounds;

import at.ridgo8.moreoverlays.chunkbounds.ChunkBoundsHandler;
import at.ridgo8.moreoverlays.config.Config;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChunkBoundsRenderer {
    private static final ResourceLocation BLANK_TEX = new ResourceLocation("moreoverlays", "textures/blank.png");
    private static final EntityRenderDispatcher render = Minecraft.m_91087_().m_91290_();

    public static void renderOverlays(PoseStack matrixstack) {
        int regionZ;
        int regionX;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.THIRD_PERSON_FRONT) {
            return;
        }
        Minecraft.m_91087_().m_91097_().m_174784_(BLANK_TEX);
        RenderSystem.m_69482_();
        RenderSystem.m_69472_();
        RenderSystem.m_69461_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_69832_((float)((float)((Double)Config.render_chunkLineWidth.get()).doubleValue()));
        RenderSystem.m_69481_();
        int h = player.f_19853_.m_141928_();
        int h0 = (int)player.m_20186_();
        int h1 = Math.min(h, h0 - 16);
        int h2 = Math.min(h, h0 + 16);
        int h3 = Math.min(h1, 0);
        int x0 = player.m_146902_().f_45578_ * 16;
        int x1 = x0 + 16;
        int x2 = x0 + 8;
        int z0 = player.m_146902_().f_45579_ * 16;
        int z1 = z0 + 16;
        int z2 = z0 + 8;
        int regionY = player.m_146902_().m_45615_().m_123342_() / 32;
        if (player.m_146902_().f_45578_ < 0) {
            regionX = (player.m_146902_().f_45578_ + 1) / 32;
            --regionX;
        } else {
            regionX = player.m_146902_().f_45578_ / 32;
        }
        if (player.m_146902_().m_45615_().m_123342_() < 0) {
            --regionY;
        }
        if (player.m_146902_().f_45579_ < 0) {
            regionZ = (player.m_146902_().f_45579_ + 1) / 32;
            --regionZ;
        } else {
            regionZ = player.m_146902_().f_45579_ / 32;
        }
        int regionBorderX0 = regionX * 32 * 16;
        int regionBorderY0 = regionY * 32 * 16;
        int regionBorderZ0 = regionZ * 32 * 16;
        int regionBorderX1 = regionBorderX0 + 512;
        int regionBorderY1 = regionBorderY0 + 512;
        int regionBorderZ1 = regionBorderZ0 + 512;
        int radius = (Integer)Config.chunk_EdgeRadius.get() * 16;
        int renderColorEdge = (Integer)Config.render_chunkEdgeColor.get();
        int renderColorMiddle = (Integer)Config.render_chunkMiddleColor.get();
        int renderColorGrid = (Integer)Config.render_chunkGridColor.get();
        for (int xo = -16 - radius; xo <= radius; xo += 16) {
            for (int yo = -16 - radius; yo <= radius; yo += 16) {
                ChunkBoundsRenderer.renderEdge(matrixstack, x0 - xo, z0 - yo, h3, h, renderColorEdge);
            }
        }
        if (((Boolean)Config.chunk_ShowMiddle.get()).booleanValue()) {
            ChunkBoundsRenderer.renderEdge(matrixstack, x2, z2, h3, h, renderColorMiddle);
        }
        if (ChunkBoundsHandler.getMode() == ChunkBoundsHandler.RenderMode.GRID) {
            ChunkBoundsRenderer.renderGrid(matrixstack, x0, h1, (float)z0 - 0.005f, x0, h2, (float)z1 + 0.005f, 1.0f, renderColorGrid);
            ChunkBoundsRenderer.renderGrid(matrixstack, x1, h1, (float)z0 - 0.005f, x1, h2, (float)z1 + 0.005f, 1.0f, renderColorGrid);
            ChunkBoundsRenderer.renderGrid(matrixstack, (float)x0 - 0.005f, h1, z0, (float)x1 + 0.005f, h2, z0, 1.0f, renderColorGrid);
            ChunkBoundsRenderer.renderGrid(matrixstack, (float)x0 - 0.005f, h1, z1, (float)x1 + 0.005f, h2, z1, 1.0f, renderColorGrid);
        } else if (ChunkBoundsHandler.getMode() == ChunkBoundsHandler.RenderMode.REGIONS) {
            ChunkBoundsRenderer.renderGrid(matrixstack, (float)regionBorderX0 - 0.005f, (float)regionBorderY0 - 0.005f, (float)regionBorderZ0 - 0.005f, (float)regionBorderX1 + 0.005f, (float)regionBorderY1 + 0.005f, (float)regionBorderZ1 + 0.005f, 16.0f, renderColorGrid);
        }
    }

    public static void renderEdge(PoseStack matrixstack, double x, double z, double h3, double h, int color) {
        Matrix4f matrix4f = matrixstack.m_85850_().m_85861_();
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tess.m_85915_();
        Minecraft minecraft = Minecraft.m_91087_();
        Camera camera = minecraft.f_91063_.m_109153_();
        double cameraX = camera.m_90583_().f_82479_;
        double cameraY = camera.m_90583_().f_82480_;
        double cameraZ = camera.m_90583_().f_82481_;
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_85982_(matrix4f, (float)(x -= cameraX), (float)(h3 -= cameraY), (float)(z -= cameraZ)).m_85950_((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f).m_5752_();
        bufferBuilder.m_85982_(matrix4f, (float)x, (float)(h -= cameraY), (float)z).m_85950_((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f).m_5752_();
        tess.m_85914_();
    }

    public static void renderEdgeOld(double x, double z, double h3, double h) {
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder renderer = tess.m_85915_();
        Minecraft minecraft = Minecraft.m_91087_();
        Camera camera = minecraft.f_91063_.m_109153_();
        Vec3 view = ChunkBoundsRenderer.render.f_114358_.m_90583_();
        double cameraX = camera.m_90583_().f_82479_;
        double cameraY = camera.m_90583_().f_82480_ - 0.005;
        double cameraZ = camera.m_90583_().f_82481_;
        double blockOffset = 0.0;
        CollisionContext collisionContext = CollisionContext.m_82750_((Entity)minecraft.f_91074_);
        VoxelShape upperOutlineShape = minecraft.f_91073_.m_8055_(new BlockPos(x, h, z)).m_60651_((BlockGetter)minecraft.f_91073_, new BlockPos(x, h, z), collisionContext);
        if (!upperOutlineShape.m_83281_()) {
            blockOffset += upperOutlineShape.m_83297_(Direction.Axis.Y);
        }
        x -= cameraX;
        h3 -= cameraY + blockOffset;
        h -= cameraY + blockOffset;
        z -= cameraZ;
        double angleA = (double)(camera.m_90590_() - 180.0f) / 57.29577951308232;
        double cosAlpha = Math.cos(-angleA);
        double sinAlpha = Math.sin(-angleA);
        double angleB = (double)camera.m_90591_().m_80150_() / 31.4;
        double cosBeta = Math.cos(-angleB);
        double sinBeta = Math.sin(-angleB);
        double angleC = (double)camera.m_90591_().m_80140_() / 31.4;
        double cosC = Math.cos(-angleC);
        double sinC = Math.sin(-angleC);
        double dX = x;
        double dY = z;
        double dZ = h;
        double x1 = dX * cosAlpha - dY * sinAlpha;
        double y1 = dX * sinAlpha + dY * cosAlpha;
        double z1 = dZ;
        double x2 = x1 * cosBeta - z1 * sinBeta;
        double y2 = y1;
        double z2 = x1 * sinBeta + z1 * cosBeta;
        double x3 = x2;
        double y3 = y2 * cosC - z2 * sinC;
        double z3 = y2 * sinC + z2 * cosC;
        x = x1;
        z = y1;
        h = z1;
        renderer.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        renderer.m_5483_(x, h3, z).m_6122_(1, 1, 1, 255).m_5752_();
        renderer.m_5483_(x, h, z).m_6122_(1, 1, 1, 255).m_5752_();
        tess.m_85914_();
    }

    public static void renderGrid(PoseStack matrixstack, float x0, float y0, float z0, float x1, float y1, float z1, float step, int color) {
        Matrix4f matrix4f = matrixstack.m_85850_().m_85861_();
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder renderer = tess.m_85915_();
        Minecraft minecraft = Minecraft.m_91087_();
        Camera camera = minecraft.f_91063_.m_109153_();
        float cameraX = (float)camera.m_90583_().f_82479_;
        float cameraY = (float)camera.m_90583_().f_82480_;
        float cameraZ = (float)camera.m_90583_().f_82481_;
        renderer.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        for (float x = x0; x <= x1; x += step) {
            renderer.m_85982_(matrix4f, x - cameraX, y0 - cameraY, z0 - cameraZ).m_85950_((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f).m_5752_();
            renderer.m_85982_(matrix4f, x - cameraX, y1 - cameraY, z0 - cameraZ).m_85950_((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f).m_5752_();
            renderer.m_85982_(matrix4f, x - cameraX, y0 - cameraY, z1 - cameraZ).m_85950_((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f).m_5752_();
            renderer.m_85982_(matrix4f, x - cameraX, y1 - cameraY, z1 - cameraZ).m_85950_((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f).m_5752_();
            renderer.m_85982_(matrix4f, x - cameraX, y0 - cameraY, z0 - cameraZ).m_85950_((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f).m_5752_();
            renderer.m_85982_(matrix4f, x - cameraX, y0 - cameraY, z1 - cameraZ).m_85950_((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f).m_5752_();
            renderer.m_85982_(matrix4f, x - cameraX, y1 - cameraY, z0 - cameraZ).m_85950_((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f).m_5752_();
            renderer.m_85982_(matrix4f, x - cameraX, y1 - cameraY, z1 - cameraZ).m_85950_((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f).m_5752_();
        }
        for (float y = y0; y <= y1; y += step) {
            renderer.m_85982_(matrix4f, x0 - cameraX, y - cameraY, z0 - cameraZ).m_85950_((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f).m_5752_();
            renderer.m_85982_(matrix4f, x1 - cameraX, y - cameraY, z0 - cameraZ).m_85950_((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f).m_5752_();
            renderer.m_85982_(matrix4f, x0 - cameraX, y - cameraY, z1 - cameraZ).m_85950_((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f).m_5752_();
            renderer.m_85982_(matrix4f, x1 - cameraX, y - cameraY, z1 - cameraZ).m_85950_((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f).m_5752_();
            renderer.m_85982_(matrix4f, x0 - cameraX, y - cameraY, z0 - cameraZ).m_85950_((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f).m_5752_();
            renderer.m_85982_(matrix4f, x0 - cameraX, y - cameraY, z1 - cameraZ).m_85950_((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f).m_5752_();
            renderer.m_85982_(matrix4f, x1 - cameraX, y - cameraY, z0 - cameraZ).m_85950_((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f).m_5752_();
            renderer.m_85982_(matrix4f, x1 - cameraX, y - cameraY, z1 - cameraZ).m_85950_((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f).m_5752_();
        }
        for (float z = z0; z <= z1; z += step) {
            renderer.m_85982_(matrix4f, x0 - cameraX, y0 - cameraY, z - cameraZ).m_85950_((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f).m_5752_();
            renderer.m_85982_(matrix4f, x1 - cameraX, y0 - cameraY, z - cameraZ).m_85950_((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f).m_5752_();
            renderer.m_85982_(matrix4f, x0 - cameraX, y1 - cameraY, z - cameraZ).m_85950_((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f).m_5752_();
            renderer.m_85982_(matrix4f, x1 - cameraX, y1 - cameraY, z - cameraZ).m_85950_((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f).m_5752_();
            renderer.m_85982_(matrix4f, x0 - cameraX, y0 - cameraY, z - cameraZ).m_85950_((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f).m_5752_();
            renderer.m_85982_(matrix4f, x0 - cameraX, y1 - cameraY, z - cameraZ).m_85950_((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f).m_5752_();
            renderer.m_85982_(matrix4f, x1 - cameraX, y0 - cameraY, z - cameraZ).m_85950_((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f).m_5752_();
            renderer.m_85982_(matrix4f, x1 - cameraX, y1 - cameraY, z - cameraZ).m_85950_((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f).m_5752_();
        }
        tess.m_85914_();
    }
}

