/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.itemsearch;

import at.ridgo8.moreoverlays.api.itemsearch.SlotHandler;
import at.ridgo8.moreoverlays.api.itemsearch.SlotViewWrapper;
import at.ridgo8.moreoverlays.config.Config;
import at.ridgo8.moreoverlays.itemsearch.GuiUtils;
import at.ridgo8.moreoverlays.itemsearch.ItemUtils;
import at.ridgo8.moreoverlays.itemsearch.JeiModule;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;

public class GuiRenderer {
    public static final GuiRenderer INSTANCE = new GuiRenderer();
    private static final float OVERLAY_ZLEVEL = 299.0f;
    private static final float FRAME_RADIUS = 1.0f;
    private static boolean enabled = false;
    private static String lastFilterText = "";
    private static boolean emptyFilter = true;
    private static BiMap<Slot, SlotViewWrapper> views = HashBiMap.create();
    private boolean allowRender = false;
    private int guiOffsetX = 0;
    private int guiOffsetY = 0;

    public void guiInit(Screen gui) {
        if (!this.canShowIn(gui)) {
            return;
        }
        this.guiOffsetX = GuiUtils.getGuiLeft((AbstractContainerScreen)gui);
        this.guiOffsetY = GuiUtils.getGuiTop((AbstractContainerScreen)gui);
    }

    public void guiOpen(Screen gui) {
    }

    public void preDraw(PoseStack matrixstack) {
        Screen guiscr = Minecraft.m_91087_().f_91080_;
        EditBox textField = JeiModule.getJEITextField();
        if (this.canShowIn(guiscr)) {
            this.allowRender = true;
            if (textField != null && enabled) {
                this.drawSearchFrame(textField, matrixstack);
            }
        }
    }

    public void postDraw() {
        Screen guiscr = Minecraft.m_91087_().f_91080_;
        if (this.allowRender && this.canShowIn(guiscr)) {
            this.allowRender = false;
            this.drawSlotOverlay((AbstractContainerScreen)guiscr);
        }
    }

    private void drawSearchFrame(EditBox textField, PoseStack matrixstack) {
        Matrix4f matrix4f = matrixstack.m_85850_().m_85861_();
        Lighting.m_84930_();
        RenderSystem.m_69482_();
        RenderSystem.m_69472_();
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder renderer = tess.m_85915_();
        float x = textField.f_93620_ + 2;
        float y = textField.f_93621_ + 2;
        float width = textField.m_5711_() - 4;
        float height = textField.m_93694_() - 4;
        renderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        renderer.m_85982_(matrix4f, x + width + 1.0f, y - 1.0f, 1000.0f).m_5752_();
        renderer.m_85982_(matrix4f, x - 1.0f, y - 1.0f, 1000.0f).m_5752_();
        renderer.m_85982_(matrix4f, x - 1.0f, y, 1000.0f).m_5752_();
        renderer.m_85982_(matrix4f, x + width + 1.0f, y, 1000.0f).m_5752_();
        renderer.m_85982_(matrix4f, x, y, 1000.0f).m_5752_();
        renderer.m_85982_(matrix4f, x - 1.0f, y, 1000.0f).m_5752_();
        renderer.m_85982_(matrix4f, x - 1.0f, y + height, 1000.0f).m_5752_();
        renderer.m_85982_(matrix4f, x, y + height, 1000.0f).m_5752_();
        renderer.m_85982_(matrix4f, x + width + 1.0f, y + height, 1000.0f).m_5752_();
        renderer.m_85982_(matrix4f, x - 1.0f, y + height, 1000.0f).m_5752_();
        renderer.m_85982_(matrix4f, x - 1.0f, y + height + 1.0f, 1000.0f).m_5752_();
        renderer.m_85982_(matrix4f, x + width + 1.0f, y + height + 1.0f, 1000.0f).m_5752_();
        renderer.m_85982_(matrix4f, x + width + 1.0f, y, 1000.0f).m_5752_();
        renderer.m_85982_(matrix4f, x + width, y, 1000.0f).m_5752_();
        renderer.m_85982_(matrix4f, x + width, y + height, 1000.0f).m_5752_();
        renderer.m_85982_(matrix4f, x + width + 1.0f, y + height, 1000.0f).m_5752_();
        tess.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    public void renderTooltip(ItemStack stack) {
        AbstractContainerScreen gui;
        Screen guiscr = Minecraft.m_91087_().f_91080_;
        if (this.allowRender && this.canShowIn(guiscr) && (gui = (AbstractContainerScreen)guiscr).getSlotUnderMouse() != null && gui.getSlotUnderMouse().m_6657_() && gui.getSlotUnderMouse().m_7993_().equals(stack)) {
            this.allowRender = false;
            this.drawSlotOverlay((AbstractContainerScreen)guiscr);
        }
    }

    private void drawSlotOverlay(AbstractContainerScreen<?> gui) {
        Lighting.m_84930_();
        if (!enabled || views == null || views.isEmpty()) {
            return;
        }
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder renderer = tess.m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        renderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        for (Map.Entry slot : views.entrySet()) {
            if (!((SlotViewWrapper)slot.getValue()).isEnableOverlay()) continue;
            Vec2 posvec = ((SlotViewWrapper)slot.getValue()).getView().getRenderPos(this.guiOffsetX, this.guiOffsetY);
            float px = posvec.f_82470_;
            float py = posvec.f_82471_;
            renderer.m_5483_((double)(px + 16.0f + (float)this.guiOffsetX), (double)(py + (float)this.guiOffsetY), 299.0).m_85950_(0.0f, 0.0f, 0.0f, 0.5f).m_5752_();
            renderer.m_5483_((double)(px + (float)this.guiOffsetX), (double)(py + (float)this.guiOffsetY), 299.0).m_85950_(0.0f, 0.0f, 0.0f, 0.5f).m_5752_();
            renderer.m_5483_((double)(px + (float)this.guiOffsetX), (double)(py + 16.0f + (float)this.guiOffsetY), 299.0).m_85950_(0.0f, 0.0f, 0.0f, 0.5f).m_5752_();
            renderer.m_5483_((double)(px + 16.0f + (float)this.guiOffsetX), (double)(py + 16.0f + (float)this.guiOffsetY), 299.0).m_85950_(0.0f, 0.0f, 0.0f, 0.5f).m_5752_();
        }
        tess.m_85914_();
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }

    public boolean canShowIn(Screen gui) {
        return gui instanceof AbstractContainerScreen && ((AbstractContainerScreen)gui).m_6262_() != null && !((AbstractContainerScreen)gui).m_6262_().f_38839_.isEmpty();
    }

    private void checkSlots(AbstractContainerScreen<?> container) {
        if (views == null) {
            views = HashBiMap.create();
        } else {
            views.clear();
        }
        for (Slot slot : container.m_6262_().f_38839_) {
            SlotViewWrapper wrapper;
            if (!views.containsKey((Object)slot)) {
                wrapper = new SlotViewWrapper(SlotHandler.INSTANCE.getViewSlot(container, slot));
                views.put((Object)slot, (Object)wrapper);
            } else {
                wrapper = (SlotViewWrapper)views.get((Object)slot);
            }
            wrapper.setEnableOverlay(wrapper.getView().canSearch() && !this.isSearchedItem(slot.m_7993_()));
        }
    }

    private boolean isSearchedItem(ItemStack stack) {
        if (emptyFilter) {
            return true;
        }
        if (stack.m_41619_()) {
            return false;
        }
        for (Object ingredient : JeiModule.filter.getFilteredIngredients(VanillaTypes.ITEM)) {
            if (!ItemUtils.ingredientMatches(ingredient, stack)) continue;
            return true;
        }
        return (Boolean)Config.search_searchCustom.get() != false && stack.m_41611_().getString().toLowerCase().contains(JeiModule.getJEITextField().m_94155_().toLowerCase());
    }

    public void tick() {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (!this.canShowIn(screen)) {
            return;
        }
        if (enabled && !JeiModule.filter.getFilterText().equals(lastFilterText)) {
            lastFilterText = JeiModule.filter.getFilterText();
            emptyFilter = lastFilterText.replace(" ", "").isEmpty();
        }
        if (enabled && screen instanceof AbstractContainerScreen) {
            this.checkSlots((AbstractContainerScreen)screen);
            this.guiOffsetX = GuiUtils.getGuiLeft((AbstractContainerScreen)screen);
            this.guiOffsetY = GuiUtils.getGuiTop((AbstractContainerScreen)screen);
        } else if (views != null) {
            views.clear();
        }
    }

    public void toggleMode() {
        boolean bl = enabled = !enabled;
        if (enabled) {
            lastFilterText = JeiModule.filter.getFilterText();
            emptyFilter = lastFilterText.replace(" ", "").isEmpty();
        } else {
            lastFilterText = "";
        }
    }

    public boolean isEnabled() {
        return enabled;
    }
}

