/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.lightoverlay;

import at.ridgo8.moreoverlays.MoreOverlays;
import at.ridgo8.moreoverlays.api.lightoverlay.ILightRenderer;
import at.ridgo8.moreoverlays.api.lightoverlay.ILightScanner;
import at.ridgo8.moreoverlays.api.lightoverlay.LightOverlayReloadHandlerEvent;
import at.ridgo8.moreoverlays.config.Config;
import at.ridgo8.moreoverlays.lightoverlay.LightOverlayRenderer;
import at.ridgo8.moreoverlays.lightoverlay.LightScannerVanilla;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

public class LightOverlayHandler {
    private static boolean OPTIFINE = false;
    private static boolean enabled = false;
    private static ILightRenderer renderer = null;
    private static ILightScanner scanner = null;
    private static boolean OptifineCheckDone;
    private static boolean setBobbing;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new LightOverlayHandler());
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean enabled) {
        if (LightOverlayHandler.enabled == enabled) {
            return;
        }
        if (enabled) {
            LightOverlayHandler.reloadHandlerInternal();
        } else {
            scanner.clear();
        }
        LightOverlayHandler.enabled = enabled;
        if (!OptifineCheckDone) {
            LightOverlayHandler.detectOptifine();
        }
        if (OPTIFINE) {
            Options settings = Minecraft.m_91087_().f_91066_;
            if (enabled) {
                setBobbing = settings.f_92080_;
                settings.f_92080_ = false;
            } else {
                settings.f_92080_ = setBobbing;
            }
        }
    }

    public static void reloadHandler() {
        if (enabled) {
            MoreOverlays.logger.info("Light overlay handlers reloaded");
            LightOverlayHandler.reloadHandlerInternal();
        }
    }

    private static void reloadHandlerInternal() {
        LightOverlayReloadHandlerEvent event = new LightOverlayReloadHandlerEvent((Boolean)Config.light_IgnoreSpawnList.get(), LightOverlayRenderer.class, LightScannerVanilla.class);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (renderer == null || renderer.getClass() != event.getRenderer()) {
            try {
                renderer = event.getRenderer().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                MoreOverlays.logger.warn((Message)new FormattedMessage("Could not create ILightRenderer from type \"%s\"!", (Object)event.getRenderer().getName()), (Throwable)e);
                renderer = new LightOverlayRenderer();
            }
        }
        if (scanner == null || scanner.getClass() != event.getScanner()) {
            if (scanner != null && enabled) {
                scanner.clear();
            }
            try {
                scanner = event.getScanner().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                MoreOverlays.logger.warn((Message)new FormattedMessage("Could not create ILightScanner from type \"%s\"!", (Object)event.getScanner().getName()), (Throwable)e);
                scanner = new LightScannerVanilla();
            }
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        LightOverlayHandler.setEnabled(false);
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderWorldLastEvent event) {
        if (enabled) {
            renderer.renderOverlays(scanner, event.getMatrixStack());
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91074_ != null && enabled && event.phase == TickEvent.Phase.END && (Minecraft.m_91087_().f_91080_ == null || !Minecraft.m_91087_().f_91080_.m_7043_())) {
            scanner.update((Player)Minecraft.m_91087_().f_91074_);
        }
    }

    private static void detectOptifine() {
        try {
            Class.forName("optifine.ZipResourceProvider");
            OPTIFINE = true;
            OptifineCheckDone = true;
        }
        catch (ClassNotFoundException e) {
            OPTIFINE = false;
            OptifineCheckDone = true;
        }
    }

    static {
        setBobbing = false;
    }
}

