/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.multimine.client;

import atomicstryker.multimine.common.MultiMine;
import atomicstryker.multimine.common.PartiallyMinedBlock;
import atomicstryker.multimine.common.network.PartialBlockPacket;
import java.io.File;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.multiplayer.PlayerController;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IClearable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="multimine")
public class MultiMineClient {
    private static MultiMineClient instance = null;
    private static Minecraft mc;
    private static PlayerEntity thePlayer;
    private final PartiallyMinedBlock[] partiallyMinedBlocksArray = new PartiallyMinedBlock[30];
    private Field vanillaDestroyProgressField = null;
    private int arrayOverWriteIndex;
    private BlockPos curBlock;
    private float lastBlockCompletion;

    public void initialize() {
        MultiMine.LOGGER.info("MultiMineClient initializing");
        this.arrayOverWriteIndex = 0;
        this.curBlock = BlockPos.field_177992_a;
        this.lastBlockCompletion = 0.0f;
    }

    public static MultiMineClient instance() {
        if (instance == null) {
            instance = new MultiMineClient();
            instance.initialize();
        }
        return instance;
    }

    @SubscribeEvent
    public static void playerLoginToServer(ClientPlayerNetworkEvent.LoggedInEvent evt) {
        mc = Minecraft.func_71410_x();
        ClientPlayerEntity loginPlayer = evt.getPlayer();
        MultiMine.LOGGER.info("MultiMineClient playerLoginToServer: " + loginPlayer);
        if (loginPlayer != null) {
            MultiMine.instance().initIfNeeded(loginPlayer.field_70170_p);
        }
    }

    public static File getMcFolder() {
        return Minecraft.func_71410_x().field_71412_D;
    }

    @SubscribeEvent
    public static void onClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        MultiMineClient.instance().onClickBlockInstance(event);
    }

    private void onClickBlockInstance(PlayerInteractEvent.LeftClickBlock event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            return;
        }
        thePlayer = event.getPlayer();
        BlockPos pos = event.getPos();
        if (!this.destroyProgressFieldFound()) {
            MultiMine.instance().debugPrint("reflection into destroyProgress not ready, aborting", new Object[0]);
            return;
        }
        TileEntity te = MultiMineClient.thePlayer.field_70170_p.func_175625_s(pos);
        if (te instanceof IClearable) {
            MultiMine.instance().debugPrint("aborting because its a container block", new Object[0]);
            return;
        }
        float destroyProgress = this.getVanillaDestroyProgressValue();
        MultiMine.instance().debugPrint("client {} clicked block {}, destroyProgress {}, lastBlockCompletion {}", thePlayer, pos, Float.valueOf(destroyProgress), Float.valueOf(this.lastBlockCompletion));
        boolean cachedProgressWasAhead = false;
        for (int i = 0; i < this.partiallyMinedBlocksArray.length; ++i) {
            if (this.partiallyMinedBlocksArray[i] == null || !this.partiallyMinedBlocksArray[i].getPos().equals((Object)pos)) continue;
            float savedProgress = this.partiallyMinedBlocksArray[i].getProgress();
            MultiMine.instance().debugPrint("found cached destroyProgress at index {}, cached: {}, mc: {}", i, Float.valueOf(savedProgress), Float.valueOf(destroyProgress));
            if (!(savedProgress > destroyProgress)) break;
            this.lastBlockCompletion = savedProgress;
            cachedProgressWasAhead = true;
            break;
        }
        if (!cachedProgressWasAhead) {
            if (!this.curBlock.equals((Object)pos)) {
                MultiMine.instance().debugPrint("client is destroying new block, was {} and now {}", pos, this.curBlock);
                this.curBlock = pos;
                this.lastBlockCompletion = destroyProgress;
            } else if (destroyProgress > this.lastBlockCompletion) {
                MultiMine.instance().debugPrint("client has block progress for: [{}], actual completion: {}, lastCompletion: {}", pos, Float.valueOf(destroyProgress), Float.valueOf(this.lastBlockCompletion));
                MultiMine.instance().networkHelper.sendPacketToServer(new PartialBlockPacket(thePlayer.func_195047_I_(), this.curBlock.func_177958_n(), this.curBlock.func_177956_o(), this.curBlock.func_177952_p(), destroyProgress, false));
                MultiMine.instance().debugPrint("sent block progress packet to server: {}", Float.valueOf(destroyProgress));
                this.lastBlockCompletion = destroyProgress;
                this.updateLocalPartialBlock(this.curBlock.func_177958_n(), this.curBlock.func_177956_o(), this.curBlock.func_177952_p(), destroyProgress, false);
            }
        } else {
            MultiMine.instance().debugPrint("overriding client destroyProgress with cache", new Object[0]);
            this.setDestroyProgressValue(this.lastBlockCompletion);
        }
    }

    private boolean destroyProgressFieldFound() {
        if (MultiMineClient.mc.field_71442_b == null) {
            return false;
        }
        if (this.vanillaDestroyProgressField != null) {
            return true;
        }
        for (Field f : PlayerController.class.getDeclaredFields()) {
            if (!f.getType().equals(Float.TYPE)) continue;
            try {
                f.setAccessible(true);
                float value = ((Float)f.get(MultiMineClient.mc.field_71442_b)).floatValue();
                if (!(value > 0.0f) || !(value < 1.0f)) continue;
                this.vanillaDestroyProgressField = f;
                return true;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("vanillaDestroyProgressField read failure", e);
            }
        }
        return false;
    }

    private float getVanillaDestroyProgressValue() {
        try {
            return ((Float)this.vanillaDestroyProgressField.get(MultiMineClient.mc.field_71442_b)).floatValue();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("vanillaDestroyProgressField read failure", e);
        }
    }

    private void setDestroyProgressValue(float lastBlockCompletion) {
        try {
            this.vanillaDestroyProgressField.set(MultiMineClient.mc.field_71442_b, Float.valueOf(lastBlockCompletion));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("vanillaDestroyProgressField write failure", e);
        }
    }

    private void renderBlockDigParticles(int x, int y, int z) {
        World world = MultiMineClient.thePlayer.field_70170_p;
        BlockPos bp = new BlockPos(x, y, z);
        BlockState state = world.func_180495_p(bp);
        Block block = state.func_177230_c();
        if (block != Blocks.field_150350_a) {
            SoundType soundtype = block.getSoundType(state, (IWorldReader)world, bp, (Entity)thePlayer);
            mc.func_147118_V().func_147682_a((ISound)new SimpleSound(soundtype.func_185846_f(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 8.0f, soundtype.func_185847_b() * 0.5f, bp));
        }
        state.addDestroyEffects(world, bp, MultiMineClient.mc.field_71452_i);
    }

    public void onServerSentPartialBlockData(int x, int y, int z, float progress, boolean regenerating) {
        if (thePlayer == null) {
            return;
        }
        MultiMine.instance().debugPrint("Client received partial Block packet for: [{}|{}|{}], progress now: {}, regen: {}", x, y, z, Float.valueOf(progress), regenerating);
        this.updateLocalPartialBlock(x, y, z, progress, regenerating);
    }

    private void updateLocalPartialBlock(int x, int y, int z, float progress, boolean regenerating) {
        PlayerEntity player = thePlayer;
        World w = player.field_70170_p;
        BlockPos pos = new BlockPos(x, y, z);
        PartiallyMinedBlock newBlock = new PartiallyMinedBlock(x, y, z, (RegistryKey<World>)MultiMineClient.thePlayer.field_70170_p.func_234923_W_(), progress);
        int freeIndex = -1;
        if (regenerating && pos.equals((Object)this.curBlock)) {
            this.lastBlockCompletion = progress;
        }
        for (int i = 0; i < this.partiallyMinedBlocksArray.length; ++i) {
            PartiallyMinedBlock iterBlock = this.partiallyMinedBlocksArray[i];
            if (iterBlock == null && freeIndex == -1) {
                freeIndex = i;
                continue;
            }
            if (!newBlock.equals(iterBlock)) continue;
            boolean notClientsBlock = false;
            if (iterBlock.getProgress() < progress && !iterBlock.getPos().equals((Object)pos)) {
                this.renderBlockDigParticles(x, y, z);
                notClientsBlock = true;
            }
            MultiMine.instance().debugPrint("Client updating local partial block [{}|{}|{}], at index {}, notClientsBlock: {}, setting progres from {} to {}", x, y, z, i, notClientsBlock, Float.valueOf(iterBlock.getProgress()), Float.valueOf(progress));
            iterBlock.setProgress(progress);
            MultiMineClient.mc.field_71441_e.func_175715_c(i, iterBlock.getPos(), Math.min(9, Math.round(10.0f * iterBlock.getProgress())));
            if (iterBlock.isFinished()) {
                MultiMineClient.mc.field_71442_b.func_187103_a(pos);
                MultiMineClient.mc.field_71441_e.func_175715_c(i, iterBlock.getPos(), 10);
                this.partiallyMinedBlocksArray[i] = null;
                if (this.curBlock.func_177958_n() == x && this.curBlock.func_177956_o() == y && this.curBlock.func_177952_p() == z) {
                    this.curBlock = BlockPos.field_177992_a;
                }
                MultiMine.instance().debugPrint("Client wiped local finished block [{}|{}|{}], at index {}", x, y, z, i);
            }
            return;
        }
        if ((double)progress > 0.99) {
            MultiMine.instance().debugPrint("Client ignoring late arrival packet [{}|{}|{}]", x, y, z);
            return;
        }
        if (freeIndex != -1) {
            this.partiallyMinedBlocksArray[freeIndex] = newBlock;
        } else {
            this.partiallyMinedBlocksArray[this.arrayOverWriteIndex++] = newBlock;
            if (this.arrayOverWriteIndex == this.partiallyMinedBlocksArray.length) {
                this.arrayOverWriteIndex = 0;
            }
        }
    }

    private void onBlockMineFinishedDamagePlayerItem(PlayerEntity player, int x, int y, int z) {
        if (x != this.curBlock.func_177958_n() || y != this.curBlock.func_177956_o() || z != this.curBlock.func_177952_p()) {
            return;
        }
        ItemStack itemStack = player.func_184614_ca();
        BlockPos pos = new BlockPos(x, y, z);
        itemStack.func_179548_a(player.field_70170_p, player.field_70170_p.func_180495_p(pos), pos, player);
        if (itemStack.func_190916_E() == 0) {
            player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
        }
    }

    public void onServerSentPartialBlockDeleteCommand(BlockPos p) {
        MultiMine.instance().debugPrint("Server sent partial delete command for [{}|{}|{}]", p.func_177958_n(), p.func_177956_o(), p.func_177952_p());
        if (this.curBlock.equals((Object)p)) {
            MultiMine.instance().debugPrint("was current block, wiping that!", new Object[0]);
            this.curBlock = BlockPos.field_177992_a;
            this.lastBlockCompletion = 0.0f;
        }
        for (int i = 0; i < this.partiallyMinedBlocksArray.length; ++i) {
            if (this.partiallyMinedBlocksArray[i] == null || !this.partiallyMinedBlocksArray[i].getPos().equals((Object)p)) continue;
            MultiMineClient.mc.field_71441_e.func_175715_c(i, this.partiallyMinedBlocksArray[i].getPos(), 10);
            this.partiallyMinedBlocksArray[i] = null;
            MultiMine.instance().debugPrint("Server sent partial delete matched at index {}, deleted!", i);
            break;
        }
    }
}

