/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.multimine.common;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

public class ItemConfigHelper {
    private final List<ItemStack> itemStackList = new ArrayList<ItemStack>();

    public ItemConfigHelper(List<? extends String> items, Logger logger) {
        for (String string : items) {
            try {
                CompoundNBT nbt = JsonToNBT.func_180713_a((String)string);
                ResourceLocation resourceLocation = new ResourceLocation(nbt.func_74779_i("nameId"));
                Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
                if (item != null) {
                    ItemStack itemStack = new ItemStack((IItemProvider)item);
                    nbt.func_82580_o("nameId");
                    if (!nbt.isEmpty()) {
                        itemStack.func_77982_d(nbt);
                    }
                    this.itemStackList.add(itemStack);
                    logger.info("item config parser identified itemstack {}", (Object)itemStack);
                    continue;
                }
                logger.error("item config parser could not identify item by resourcelocation {}", (Object)resourceLocation);
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        }
        logger.info("item config parser finished, item count: {}", (Object)this.itemStackList.size());
    }

    public static String fromItemStack(ItemStack itemStack) {
        itemStack.func_196082_o().func_74778_a("nameId", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)itemStack.func_77973_b()).toString());
        return itemStack.func_196082_o().toString();
    }

    public List<ItemStack> getItemStackList() {
        return this.itemStackList;
    }
}

