/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.multimine.common;

import atomicstryker.multimine.common.MultiMine;
import atomicstryker.multimine.common.PartiallyMinedBlock;
import atomicstryker.multimine.common.network.PartialBlockPacket;
import atomicstryker.multimine.common.network.PartialBlockRemovalPacket;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MultiMineServer {
    private static MultiMineServer instance;
    private static MinecraftServer serverInstance;
    private final HashMap<RegistryKey<World>, List<PartiallyMinedBlock>> partiallyMinedBlocksListByDimension;
    private final BlockRegenQueue blockRegenQueue;

    public MultiMineServer() {
        MultiMine.LOGGER.info("MultiMineServer initializing");
        instance = this;
        this.partiallyMinedBlocksListByDimension = Maps.newHashMap();
        this.blockRegenQueue = new BlockRegenQueue(30, new BlockAgeComparator());
    }

    public static MultiMineServer instance() {
        return instance;
    }

    public void onClientSentPartialBlockPacket(ServerPlayerEntity player, int x, int y, int z, float value) {
        serverInstance = ServerLifecycleHooks.getCurrentServer();
        RegistryKey dimension = player.func_71121_q().func_234923_W_();
        MultiMine.instance().debugPrint("multi mine client {} sent progress packet: {}", player.func_200200_C_().func_150261_e(), Float.valueOf(value));
        BlockPos pos = new BlockPos(x, y, z);
        BlockState iblockstate = player.func_71121_q().func_180495_p(pos);
        if (this.isUsingBannedItem((PlayerEntity)player) || this.isBlockBanned(iblockstate)) {
            return;
        }
        ArrayList partiallyMinedBlocks = this.getPartiallyMinedBlocksForDimension((RegistryKey<World>)dimension);
        if (partiallyMinedBlocks == null) {
            partiallyMinedBlocks = Lists.newArrayList();
            this.partiallyMinedBlocksListByDimension.put((RegistryKey<World>)dimension, partiallyMinedBlocks);
        }
        PartiallyMinedBlock newblock = new PartiallyMinedBlock(x, y, z, (RegistryKey<World>)dimension, 0.0f);
        newblock.setLastTimeMined(System.currentTimeMillis() + MultiMine.instance().getInitialBlockRegenDelay());
        for (PartiallyMinedBlock iterBlock : partiallyMinedBlocks) {
            if (!iterBlock.equals(newblock)) continue;
            iterBlock.setProgress(Math.max(iterBlock.getProgress(), value));
            iterBlock.setLastTimeMined(System.currentTimeMillis() + MultiMine.instance().getInitialBlockRegenDelay());
            MultiMine.instance().debugPrint("Server updating partial block at: [{}|{}|{}], progress now: {}", x, y, z, Float.valueOf(iterBlock.getProgress()));
            this.sendPartiallyMinedBlockUpdateToAllPlayers(iterBlock, false);
            if (iterBlock.isFinished() && !player.func_71121_q().func_180495_p(pos).func_196958_f()) {
                MultiMine.instance().debugPrint("Server destroying block at: [{}|{}|{}]", x, y, z);
                player.field_71134_c.func_180237_b(pos);
                partiallyMinedBlocks.remove(iterBlock);
                this.blockRegenQueue.remove(iterBlock);
            } else {
                this.blockRegenQueue.offer(iterBlock);
            }
            return;
        }
        if (partiallyMinedBlocks.size() > 29) {
            PartiallyMinedBlock old = (PartiallyMinedBlock)partiallyMinedBlocks.get(0);
            this.sendPartiallyMinedBlockDeleteCommandToAllPlayers(old);
            partiallyMinedBlocks.remove(old);
            this.blockRegenQueue.remove(old);
        }
        partiallyMinedBlocks.add(newblock);
        this.blockRegenQueue.offer(newblock);
        this.sendPartiallyMinedBlockUpdateToAllPlayers(newblock, false);
    }

    private boolean isBlockBanned(BlockState blockState) {
        String ident = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)blockState.func_177230_c()).toString();
        Boolean result = MultiMine.instance().getConfig().getBannedBlocks().get(ident);
        if (result != null) {
            return result;
        }
        result = false;
        MultiMine.instance().getConfig().getBannedBlocks().put(ident, result);
        MultiMine.instance().saveConfig();
        return result;
    }

    private boolean isUsingBannedItem(PlayerEntity player) {
        ItemStack item = player.func_184614_ca();
        String ident = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item.func_77973_b()).toString();
        Boolean result = MultiMine.instance().getConfig().getBannedItems().get(ident);
        if (result != null) {
            return result;
        }
        result = false;
        MultiMine.instance().getConfig().getBannedItems().put(ident, result);
        MultiMine.instance().saveConfig();
        return result;
    }

    private void sendPartiallyMinedBlockDeleteCommandToAllPlayers(PartiallyMinedBlock block) {
        MultiMine.instance().networkHelper.sendPacketToAllAroundPoint(new PartialBlockRemovalPacket(block.getPos()), new PacketDistributor.TargetPoint((double)block.getPos().func_177958_n(), (double)block.getPos().func_177956_o(), (double)block.getPos().func_177952_p(), 30.0, block.getDimension()));
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        MultiMineServer.instance().onPlayerLoginInstance(event);
    }

    private void onPlayerLoginInstance(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        RegistryKey dimensionKey = player.field_70170_p.func_234923_W_();
        List<PartiallyMinedBlock> partiallyMinedBlocks = this.getPartiallyMinedBlocksForDimension((RegistryKey<World>)dimensionKey);
        if (partiallyMinedBlocks != null) {
            for (PartiallyMinedBlock block : partiallyMinedBlocks) {
                this.sendPartiallyMinedBlockToPlayer((ServerPlayerEntity)player, block);
            }
        }
    }

    private List<PartiallyMinedBlock> getPartiallyMinedBlocksForDimension(RegistryKey<World> dim) {
        return this.partiallyMinedBlocksListByDimension.get(dim);
    }

    private void sendPartiallyMinedBlockUpdateToAllPlayers(PartiallyMinedBlock block, boolean regenerating) {
        MultiMine.instance().networkHelper.sendPacketToAllAroundPoint(new PartialBlockPacket("server", block.getPos().func_177958_n(), block.getPos().func_177956_o(), block.getPos().func_177952_p(), block.getProgress(), regenerating), new PacketDistributor.TargetPoint((double)block.getPos().func_177958_n(), (double)block.getPos().func_177956_o(), (double)block.getPos().func_177952_p(), 32.0, block.getDimension()));
    }

    private void sendPartiallyMinedBlockToPlayer(ServerPlayerEntity p, PartiallyMinedBlock block) {
        MultiMine.instance().networkHelper.sendPacketToPlayer(new PartialBlockPacket("server", block.getPos().func_177958_n(), block.getPos().func_177956_o(), block.getPos().func_177952_p(), block.getProgress(), false), p);
    }

    @SubscribeEvent
    public void commonSetup(FMLServerStartedEvent evt) {
        MultiMine.LOGGER.info("MultiMine ServerStartedEvent");
        MultiMine.instance().initIfNeeded((World)evt.getServer().func_212370_w().iterator().next());
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent tick) {
        PartiallyMinedBlock block;
        if (tick.phase != TickEvent.Phase.END || this.blockRegenQueue.isEmpty()) {
            return;
        }
        Iterator iter = this.blockRegenQueue.iterator();
        while (iter.hasNext()) {
            block = (PartiallyMinedBlock)iter.next();
            if (!this.isBlockGone(block)) continue;
            this.sendPartiallyMinedBlockDeleteCommandToAllPlayers(block);
            this.getPartiallyMinedBlocksForDimension(block.getDimension()).remove(block);
            iter.remove();
        }
        if (this.blockRegenQueue.isEmpty() || !MultiMine.instance().getBlockRegenEnabled()) {
            return;
        }
        long curTime = System.currentTimeMillis();
        if (((PartiallyMinedBlock)this.blockRegenQueue.peek()).getLastTimeMined() + MultiMine.instance().getBlockRegenInterval() < curTime) {
            block = (PartiallyMinedBlock)this.blockRegenQueue.poll();
            block.setProgress(block.getProgress() - 0.1f);
            block.setLastTimeMined(curTime);
            if (block.getProgress() < 0.0f) {
                MultiMine.instance().debugPrint("Server sending partial delete command for [{}|{}|{}]", block.getPos().func_177958_n(), block.getPos().func_177956_o(), block.getPos().func_177952_p());
                this.sendPartiallyMinedBlockDeleteCommandToAllPlayers(block);
                this.getPartiallyMinedBlocksForDimension(block.getDimension()).remove(block);
            } else {
                MultiMine.instance().debugPrint("Server sending partial regen update for [{}|{}|{}]", block.getPos().func_177958_n(), block.getPos().func_177956_o(), block.getPos().func_177952_p());
                this.sendPartiallyMinedBlockUpdateToAllPlayers(block, true);
                this.blockRegenQueue.add(block);
            }
        }
    }

    private boolean isBlockGone(PartiallyMinedBlock block) {
        return serverInstance.func_71218_a(block.getDimension()).func_175623_d(block.getPos());
    }

    private static class BlockRegenQueue
    extends PriorityQueue<PartiallyMinedBlock> {
        private static final long serialVersionUID = 1L;

        BlockRegenQueue(int initialSize, Comparator<PartiallyMinedBlock> comparator) {
            super(initialSize, comparator);
        }

        @Override
        public boolean offer(PartiallyMinedBlock block) {
            if (this.contains(block)) {
                this.remove(block);
            }
            return super.offer(block);
        }
    }

    private static class BlockAgeComparator
    implements Comparator<PartiallyMinedBlock> {
        private BlockAgeComparator() {
        }

        @Override
        public int compare(PartiallyMinedBlock b1, PartiallyMinedBlock b2) {
            return Long.compare(b1.getLastTimeMined(), b2.getLastTimeMined());
        }
    }
}

