/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.multimine.common.network;

import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHelper {
    private final SimpleChannel packetChannel;
    private final HashSet<Class<? extends IPacket>> registeredClasses;

    @SafeVarargs
    public NetworkHelper(String channelName, Class<? extends IPacket> ... handledPacketClasses) {
        this.packetChannel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(channelName)).clientAcceptedVersions(a -> true).serverAcceptedVersions(a -> true).networkProtocolVersion(() -> "1.0.0").simpleChannel();
        this.registeredClasses = new HashSet(handledPacketClasses.length);
        this.registeredClasses.addAll(Arrays.asList(handledPacketClasses));
        int runningIndex = 0;
        for (Class<? extends IPacket> packetClass : handledPacketClasses) {
            try {
                IPacket instance = packetClass.newInstance();
                int n = runningIndex++;
                this.packetChannel.registerMessage(n, packetClass, instance::encode, instance::decode, instance::handle);
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
    }

    public void sendPacketToServer(IPacket packet) {
        this.checkClass(packet.getClass());
        this.packetChannel.sendToServer((Object)packet);
    }

    public void sendPacketToPlayer(IPacket packet, ServerPlayer player) {
        this.checkClass(packet.getClass());
        this.packetChannel.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    public void sendPacketToAllPlayers(IPacket packet) {
        this.checkClass(packet.getClass());
        this.packetChannel.send(PacketDistributor.ALL.noArg(), (Object)packet);
    }

    public void sendPacketToAllAroundPoint(IPacket packet, PacketDistributor.TargetPoint tp) {
        this.checkClass(packet.getClass());
        this.packetChannel.send(PacketDistributor.NEAR.with(() -> tp), (Object)packet);
    }

    private void checkClass(Class<? extends IPacket> clazz) {
        if (!this.registeredClasses.contains(clazz)) {
            throw new RuntimeException("NetworkHelper got unknown Packet type " + clazz + " to send, critical error");
        }
    }

    public static interface IPacket {
        public void encode(Object var1, FriendlyByteBuf var2);

        public <MSG> MSG decode(FriendlyByteBuf var1);

        public void handle(Object var1, Supplier<NetworkEvent.Context> var2);
    }
}

