/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.multimine.common;

import atomicstryker.multimine.client.MultiMineClient;
import atomicstryker.multimine.common.GsonConfig;
import atomicstryker.multimine.common.MultiMineConfig;
import atomicstryker.multimine.common.MultiMineServer;
import atomicstryker.multimine.common.network.PartialBlockPacket;
import atomicstryker.multimine.common.network.PartialBlockRemovalPacket;
import java.io.File;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="multimine")
@Mod.EventBusSubscriber(modid="multimine")
public class MultiMine {
    public static final String MOD_ID = "multimine";
    private static MultiMine instance;
    public static Logger LOGGER;
    private File configFile;
    private MultiMineConfig config;
    public static SimpleChannel networkChannel;

    public MultiMine() {
        instance = this;
        LOGGER = LogManager.getLogger();
        LOGGER.info("mod instantiated");
        MinecraftForge.EVENT_BUS.register((Object)new MultiMineServer());
    }

    public void initIfNeeded(Level world) {
        if (this.configFile == null) {
            File mcFolder;
            if (world.m_5776_()) {
                mcFolder = MultiMineClient.getMcFolder();
            } else {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                mcFolder = server.m_129971_("");
            }
            this.configFile = new File(mcFolder, File.separatorChar + "config" + File.separatorChar + "multimine.cfg");
            this.loadConfig();
        }
    }

    private void loadConfig() {
        MultiMineConfig defaultConfig = new MultiMineConfig();
        defaultConfig.setDisableForAllTileEntities(false);
        LOGGER.info("config loading now");
        this.config = GsonConfig.loadConfigWithDefault(MultiMineConfig.class, this.configFile, defaultConfig);
        LOGGER.info("config loaded successfully");
    }

    public static MultiMine instance() {
        return instance;
    }

    public boolean getBlockRegenEnabled() {
        return this.config.isBlockRegenerationEnabled();
    }

    public long getInitialBlockRegenDelay() {
        return this.config.getInitialBlockRegenDelayMillis();
    }

    public long getBlockRegenInterval() {
        return this.config.getBlockRegenIntervalMillis();
    }

    public MultiMineConfig getConfig() {
        return this.config;
    }

    public void saveConfig() {
        GsonConfig.saveConfig(this.config, this.configFile);
    }

    public void debugPrint(String s, Object ... params) {
        if (this.config.isDebugMode()) {
            LOGGER.info(s, params);
        }
    }

    static {
        networkChannel = ChannelBuilder.named((ResourceLocation)new ResourceLocation("as_mm")).clientAcceptedVersions((status, version) -> true).serverAcceptedVersions((status, version) -> true).networkProtocolVersion(1).simpleChannel().messageBuilder(PartialBlockPacket.class).decoder(PartialBlockPacket::decode).encoder(PartialBlockPacket::encode).consumerNetworkThread(PartialBlockPacket::handle).add().messageBuilder(PartialBlockRemovalPacket.class).decoder(PartialBlockRemovalPacket::decode).encoder(PartialBlockRemovalPacket::encode).consumerNetworkThread(PartialBlockRemovalPacket::handle).add();
    }
}

