/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.multimine.common.network;

import atomicstryker.multimine.client.MultiMineClient;
import atomicstryker.multimine.common.MultiMineServer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public record PartialBlockPacket(String user, int x, int y, int z, float value, boolean regenerating) {
    private static final int MAX_NAME_LENGTH = 256;

    public void encode(FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130072_(this.user, 256);
        packetBuffer.writeInt(this.x);
        packetBuffer.writeInt(this.y);
        packetBuffer.writeInt(this.z);
        packetBuffer.writeFloat(this.value);
        packetBuffer.writeBoolean(this.regenerating);
    }

    public static PartialBlockPacket decode(FriendlyByteBuf packetBuffer) {
        return new PartialBlockPacket(packetBuffer.m_130136_(256), packetBuffer.readInt(), packetBuffer.readInt(), packetBuffer.readInt(), packetBuffer.readFloat(), packetBuffer.readBoolean());
    }

    public static void handle(PartialBlockPacket packet, CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> {
            if (packet.user.equals("server")) {
                context.enqueueWork(() -> MultiMineClient.instance().onServerSentPartialBlockData(packet.x, packet.y, packet.z, packet.value, packet.regenerating));
            } else {
                ServerPlayer p = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11255_(packet.user);
                if (p != null) {
                    context.enqueueWork(() -> MultiMineServer.instance().onClientSentPartialBlockPacket(p, packet.x, packet.y, packet.z, packet.value));
                }
            }
        });
        context.setPacketHandled(true);
    }
}

