/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.multimine.common.network;

import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;

public class NetworkHelper {
    private final SimpleChannel packetChannel;
    private final HashSet<Class<? extends IPacket>> registeredClasses;

    @SafeVarargs
    public NetworkHelper(String channelName, Class<? extends IPacket> ... handledPacketClasses) {
        this.packetChannel = ChannelBuilder.named((ResourceLocation)new ResourceLocation(channelName)).clientAcceptedVersions((status, version) -> true).serverAcceptedVersions((status, version) -> true).networkProtocolVersion(0).simpleChannel();
        this.registeredClasses = new HashSet(handledPacketClasses.length);
        this.registeredClasses.addAll(Arrays.asList(handledPacketClasses));
        boolean runningIndex = false;
        for (Class<? extends IPacket> packetClass : handledPacketClasses) {
            try {
                IPacket instance = packetClass.newInstance();
                this.packetChannel.messageBuilder(instance.getClass()).decoder(instance::decode).encoder(instance::encode).consumerNetworkThread(instance::handle).add();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
    }

    public void sendPacketToServer(IPacket packet) {
        this.checkClass(packet.getClass());
        this.packetChannel.send((Object)packet, PacketDistributor.SERVER.noArg());
    }

    public void sendPacketToPlayer(IPacket packet, ServerPlayer player) {
        this.checkClass(packet.getClass());
        this.packetChannel.send((Object)packet, PacketDistributor.PLAYER.with((Object)player));
    }

    public void sendPacketToAllPlayers(IPacket packet) {
        this.checkClass(packet.getClass());
        this.packetChannel.send((Object)packet, PacketDistributor.ALL.noArg());
    }

    public void sendPacketToAllAroundPoint(IPacket packet, PacketDistributor.TargetPoint tp) {
        this.checkClass(packet.getClass());
        this.packetChannel.send((Object)packet, PacketDistributor.NEAR.with((Object)tp));
    }

    private void checkClass(Class<? extends IPacket> clazz) {
        if (!this.registeredClasses.contains(clazz)) {
            throw new RuntimeException("NetworkHelper got unknown Packet type " + clazz + " to send, critical error");
        }
    }

    public static interface IPacket {
        public void encode(Object var1, FriendlyByteBuf var2);

        public <MSG> MSG decode(FriendlyByteBuf var1);

        public void handle(Object var1, CustomPayloadEvent.Context var2);
    }
}

