/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.multimine.common.network;

import atomicstryker.multimine.client.MultiMineClient;
import atomicstryker.multimine.common.MultiMineServer;
import atomicstryker.multimine.common.network.NetworkHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PartialBlockPacket
implements NetworkHelper.IPacket {
    private int MAX_NAME_LENGTH = 256;
    private String user;
    private int x;
    private int y;
    private int z;
    private float value;
    private boolean regenerating;

    public PartialBlockPacket() {
    }

    public PartialBlockPacket(String username, int ix, int iy, int iz, float val, boolean regen) {
        this.user = username;
        this.x = ix;
        this.y = iy;
        this.z = iz;
        this.value = val;
        this.regenerating = regen;
    }

    @Override
    public void encode(Object msg, FriendlyByteBuf packetBuffer) {
        PartialBlockPacket packet = (PartialBlockPacket)msg;
        packetBuffer.m_130072_(packet.user, this.MAX_NAME_LENGTH);
        packetBuffer.writeInt(packet.x);
        packetBuffer.writeInt(packet.y);
        packetBuffer.writeInt(packet.z);
        packetBuffer.writeFloat(packet.value);
        packetBuffer.writeBoolean(packet.regenerating);
    }

    @Override
    public <MSG> MSG decode(FriendlyByteBuf packetBuffer) {
        PartialBlockPacket packet = new PartialBlockPacket(packetBuffer.m_130136_(this.MAX_NAME_LENGTH), packetBuffer.readInt(), packetBuffer.readInt(), packetBuffer.readInt(), packetBuffer.readFloat(), packetBuffer.readBoolean());
        return (MSG)packet;
    }

    @Override
    public void handle(Object msg, CustomPayloadEvent.Context context) {
        PartialBlockPacket packet = (PartialBlockPacket)msg;
        ((BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(context.getDirection().getReceptionSide())).m_18707_(() -> {
            if (packet.user.equals("server")) {
                ((BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(context.getDirection().getReceptionSide())).m_18707_(() -> MultiMineClient.instance().onServerSentPartialBlockData(packet.x, packet.y, packet.z, packet.value, packet.regenerating));
            } else {
                ServerPlayer p = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11255_(packet.user);
                if (p != null) {
                    ((BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(context.getDirection().getReceptionSide())).m_18707_(() -> MultiMineServer.instance().onClientSentPartialBlockPacket(p, packet.x, packet.y, packet.z, packet.value));
                }
            }
        });
        context.setPacketHandled(true);
    }
}

