/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.multimine.client;

import atomicstryker.multimine.common.MultiMine;
import atomicstryker.multimine.common.PartiallyMinedBlock;
import atomicstryker.multimine.common.network.PartialBlockPacket;
import java.io.File;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="multimine")
public class MultiMineClient {
    private static MultiMineClient instance = null;
    private static Minecraft mc;
    private static Player thePlayer;
    private final PartiallyMinedBlock[] partiallyMinedBlocksArray = new PartiallyMinedBlock[30];
    private Field vanillaDestroyProgressField = null;
    private int arrayOverWriteIndex;
    private BlockPos lastClickedBlock;
    private float lastBlockCompletion;

    public void initialize() {
        MultiMine.LOGGER.info("MultiMineClient initializing");
        this.arrayOverWriteIndex = 0;
        this.lastClickedBlock = BlockPos.ZERO;
        this.lastBlockCompletion = 0.0f;
    }

    public static MultiMineClient instance() {
        if (instance == null) {
            instance = new MultiMineClient();
            instance.initialize();
        }
        return instance;
    }

    @SubscribeEvent
    public static void playerLoginToServer(ClientPlayerNetworkEvent.LoggingIn evt) {
        mc = Minecraft.getInstance();
        MultiMine.LOGGER.info("MultiMineClient playerLoginToServer: " + evt.getPlayer());
        MultiMine.instance().initIfNeeded(evt.getPlayer().level());
    }

    public static File getMcFolder() {
        return Minecraft.getInstance().gameDirectory;
    }

    @SubscribeEvent
    public static void onClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        MultiMineClient.instance().onClickBlockInstance(event);
    }

    private void onClickBlockInstance(PlayerInteractEvent.LeftClickBlock event) {
        if (!event.getEntity().level().isClientSide) {
            return;
        }
        thePlayer = event.getEntity();
        BlockPos pos = event.getPos();
        if (!this.destroyProgressFieldFound()) {
            MultiMine.instance().debugPrint("reflection into destroyProgress not ready, aborting", new Object[0]);
            return;
        }
        BlockEntity blockentity = thePlayer.level().getBlockEntity(pos);
        if (blockentity instanceof Container) {
            MultiMine.instance().debugPrint("aborting because its a container block", new Object[0]);
            return;
        }
        float destroyProgressVanilla = this.getVanillaDestroyProgressValue();
        MultiMine.instance().debugPrint("client {} clicked block {}, destroyProgress {}, lastBlockCompletion {}", thePlayer, pos, Float.valueOf(destroyProgressVanilla), Float.valueOf(this.lastBlockCompletion));
        boolean cachedProgressWasAhead = false;
        for (int i = 0; i < this.partiallyMinedBlocksArray.length; ++i) {
            if (this.partiallyMinedBlocksArray[i] == null || !this.partiallyMinedBlocksArray[i].getPos().equals((Object)pos)) continue;
            float savedProgress = this.partiallyMinedBlocksArray[i].getProgress();
            MultiMine.instance().debugPrint("found cached destroyProgress at index {}, cached: {}, mc: {}", i, Float.valueOf(savedProgress), Float.valueOf(destroyProgressVanilla));
            if (!(savedProgress > destroyProgressVanilla)) break;
            this.lastBlockCompletion = savedProgress;
            cachedProgressWasAhead = true;
            break;
        }
        if (!cachedProgressWasAhead) {
            if (!this.lastClickedBlock.equals((Object)pos)) {
                MultiMine.instance().debugPrint("client is destroying new block, was {} and now {}", this.lastClickedBlock, pos);
                this.lastClickedBlock = pos;
                this.lastBlockCompletion = 0.0f;
            } else if (destroyProgressVanilla > this.lastBlockCompletion) {
                MultiMine.instance().debugPrint("client has block progress for: [{}], actual completion: {}, lastCompletion: {}", pos, Float.valueOf(destroyProgressVanilla), Float.valueOf(this.lastBlockCompletion));
                PartialBlockPacket partialBlockPacket = new PartialBlockPacket(thePlayer.getScoreboardName(), this.lastClickedBlock.getX(), this.lastClickedBlock.getY(), this.lastClickedBlock.getZ(), destroyProgressVanilla, false);
                PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{partialBlockPacket});
                MultiMine.instance().debugPrint("sent block progress packet to server: {}", Float.valueOf(destroyProgressVanilla));
                this.lastBlockCompletion = destroyProgressVanilla;
                this.updateLocalPartialBlock(this.lastClickedBlock.getX(), this.lastClickedBlock.getY(), this.lastClickedBlock.getZ(), destroyProgressVanilla, false);
            }
        } else {
            MultiMine.instance().debugPrint("overriding client destroyProgress {} with multi mine cache {}", Float.valueOf(destroyProgressVanilla), Float.valueOf(this.lastBlockCompletion));
            this.setDestroyProgressValue(this.lastBlockCompletion);
        }
    }

    private boolean destroyProgressFieldFound() {
        if (MultiMineClient.mc.gameMode == null) {
            return false;
        }
        if (this.vanillaDestroyProgressField != null) {
            return true;
        }
        for (Field f : MultiPlayerGameMode.class.getDeclaredFields()) {
            if (!f.getType().equals(Float.TYPE)) continue;
            try {
                f.setAccessible(true);
                float value = ((Float)f.get(MultiMineClient.mc.gameMode)).floatValue();
                if (!(value > 0.0f) || !(value < 1.0f)) continue;
                this.vanillaDestroyProgressField = f;
                return true;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("vanillaDestroyProgressField read failure", e);
            }
        }
        return false;
    }

    private float getVanillaDestroyProgressValue() {
        try {
            return ((Float)this.vanillaDestroyProgressField.get(MultiMineClient.mc.gameMode)).floatValue();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("vanillaDestroyProgressField read failure", e);
        }
    }

    private void setDestroyProgressValue(float lastBlockCompletion) {
        try {
            this.vanillaDestroyProgressField.set(MultiMineClient.mc.gameMode, Float.valueOf(lastBlockCompletion));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("vanillaDestroyProgressField write failure", e);
        }
    }

    private void renderBlockDigParticles(int x, int y, int z) {
        BlockPos bp;
        Level world = thePlayer.level();
        BlockState state = world.getBlockState(bp = new BlockPos(x, y, z));
        Block block = state.getBlock();
        if (block != Blocks.AIR) {
            SoundType soundtype = block.getSoundType(state, (LevelReader)world, bp, (Entity)thePlayer);
            mc.getSoundManager().play((SoundInstance)new SimpleSoundInstance(soundtype.getHitSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 8.0f, soundtype.getPitch() * 0.5f, thePlayer.getRandom(), bp));
        }
        world.addDestroyBlockEffect(bp, state);
    }

    public void onServerSentPartialBlockData(int x, int y, int z, float progress, boolean regenerating) {
        if (thePlayer == null) {
            return;
        }
        MultiMine.instance().debugPrint("Client received partial Block packet for: [{}|{}|{}], progress now: {}, regen: {}", x, y, z, Float.valueOf(progress), regenerating);
        this.updateLocalPartialBlock(x, y, z, progress, regenerating);
    }

    private void updateLocalPartialBlock(int x, int y, int z, float progress, boolean regenerating) {
        BlockPos pos = new BlockPos(x, y, z);
        PartiallyMinedBlock newBlock = new PartiallyMinedBlock(x, y, z, (ResourceKey<Level>)thePlayer.level().dimension(), progress);
        int freeIndex = -1;
        if (regenerating && pos.equals((Object)this.lastClickedBlock) && progress >= 0.0f) {
            this.lastBlockCompletion = progress;
        }
        for (int arrayIndex = 0; arrayIndex < this.partiallyMinedBlocksArray.length; ++arrayIndex) {
            PartiallyMinedBlock iterBlock = this.partiallyMinedBlocksArray[arrayIndex];
            if (iterBlock == null && freeIndex == -1) {
                freeIndex = arrayIndex;
                continue;
            }
            if (!newBlock.equals(iterBlock)) continue;
            if (progress < 0.0f) {
                MultiMine.instance().debugPrint("Client was told to forget progress for partial block [{}|{}|{}], at index {}, it is blacklisted", x, y, z, arrayIndex);
                this.partiallyMinedBlocksArray[arrayIndex] = null;
                return;
            }
            boolean notClientsBlock = false;
            if (iterBlock.getProgress() < progress && !iterBlock.getPos().equals((Object)pos)) {
                this.renderBlockDigParticles(x, y, z);
                notClientsBlock = true;
            }
            MultiMine.instance().debugPrint("Client updating local partial block [{}|{}|{}], at index {}, notClientsBlock: {}, setting progress from {} to {}", x, y, z, arrayIndex, notClientsBlock, Float.valueOf(iterBlock.getProgress()), Float.valueOf(progress));
            iterBlock.setProgress(progress);
            MultiMineClient.mc.level.destroyBlockProgress(arrayIndex, iterBlock.getPos(), Math.min(9, Math.round(10.0f * iterBlock.getProgress())));
            if (iterBlock.isFinished()) {
                MultiMineClient.mc.gameMode.destroyBlock(pos);
                MultiMineClient.mc.level.destroyBlockProgress(arrayIndex, iterBlock.getPos(), 10);
                this.partiallyMinedBlocksArray[arrayIndex] = null;
                if (this.lastClickedBlock.getX() == x && this.lastClickedBlock.getY() == y && this.lastClickedBlock.getZ() == z) {
                    this.lastClickedBlock = BlockPos.ZERO;
                }
                MultiMine.instance().debugPrint("Client wiped local finished block [{}|{}|{}], at index {}", x, y, z, arrayIndex);
            }
            return;
        }
        if ((double)progress > 0.99) {
            MultiMine.instance().debugPrint("Client ignoring late arrival packet [{}|{}|{}]", x, y, z);
            return;
        }
        if (freeIndex != -1) {
            this.partiallyMinedBlocksArray[freeIndex] = newBlock;
        } else {
            this.partiallyMinedBlocksArray[this.arrayOverWriteIndex++] = newBlock;
            if (this.arrayOverWriteIndex == this.partiallyMinedBlocksArray.length) {
                this.arrayOverWriteIndex = 0;
            }
        }
    }

    private void onBlockMineFinishedDamagePlayerItem(Player player, int x, int y, int z) {
        if (x != this.lastClickedBlock.getX() || y != this.lastClickedBlock.getY() || z != this.lastClickedBlock.getZ()) {
            return;
        }
        ItemStack itemStack = player.getMainHandItem();
        BlockPos pos = new BlockPos(x, y, z);
        itemStack.mineBlock(player.level(), player.level().getBlockState(pos), pos, player);
        if (itemStack.getCount() == 0) {
            player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        }
    }

    public void onServerSentPartialBlockDeleteCommand(BlockPos p) {
        if (MultiMineClient.mc.level == null) {
            return;
        }
        MultiMine.instance().debugPrint("Server sent partial delete command for [{}|{}|{}]", p.getX(), p.getY(), p.getZ());
        if (this.lastClickedBlock.equals((Object)p)) {
            MultiMine.instance().debugPrint("was current block, wiping that!", new Object[0]);
            this.lastClickedBlock = BlockPos.ZERO;
            this.lastBlockCompletion = 0.0f;
        }
        for (int i = 0; i < this.partiallyMinedBlocksArray.length; ++i) {
            if (this.partiallyMinedBlocksArray[i] == null || !this.partiallyMinedBlocksArray[i].getPos().equals((Object)p)) continue;
            MultiMineClient.mc.level.destroyBlockProgress(i, this.partiallyMinedBlocksArray[i].getPos(), 10);
            this.partiallyMinedBlocksArray[i] = null;
            MultiMine.instance().debugPrint("Server sent partial delete matched at index {}, deleted!", i);
            break;
        }
    }
}

