/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.multimine.common;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.Logger;

public class ItemConfigHelper {
    private final List<ItemStack> itemStackList = new ArrayList<ItemStack>();

    public ItemConfigHelper(List<? extends String> items, Logger logger) {
        for (String string : items) {
            try {
                CompoundTag nbt = TagParser.parseTag((String)string);
                ResourceLocation resourceLocation = new ResourceLocation(nbt.getString("nameId"));
                Optional itemOptional = BuiltInRegistries.ITEM.getOptional(resourceLocation);
                if (itemOptional.isPresent()) {
                    ItemStack itemStack = new ItemStack((ItemLike)itemOptional.get());
                    nbt.remove("nameId");
                    if (!nbt.isEmpty()) {
                        itemStack.setTag(nbt);
                    }
                    this.itemStackList.add(itemStack);
                    logger.info("item config parser identified itemstack {}", (Object)itemStack);
                    continue;
                }
                logger.error("item config parser could not identify item by resourcelocation {}", (Object)resourceLocation);
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        }
        logger.info("item config parser finished, item count: {}", (Object)this.itemStackList.size());
    }

    public static String fromItemStack(ItemStack itemStack) {
        itemStack.getOrCreateTag().putString("nameId", BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).toString());
        return itemStack.getOrCreateTag().toString();
    }

    public List<ItemStack> getItemStackList() {
        return this.itemStackList;
    }
}

