/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.multimine.common;

import atomicstryker.multimine.client.MultiMineClient;
import atomicstryker.multimine.common.GsonConfig;
import atomicstryker.multimine.common.MultiMineConfig;
import atomicstryker.multimine.common.MultiMineServer;
import atomicstryker.multimine.common.network.PartialBlockPacket;
import atomicstryker.multimine.common.network.PartialBlockRemovalPacket;
import java.io.File;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="multimine")
public class MultiMine {
    public static final String MOD_ID = "multimine";
    private static MultiMine instance;
    public static Logger LOGGER;
    private File configFile;
    private MultiMineConfig config;

    public MultiMine(IEventBus modEventBus) {
        instance = this;
        LOGGER = LogManager.getLogger();
        LOGGER.info("mod instantiated");
        NeoForge.EVENT_BUS.register((Object)new MultiMineServer());
        modEventBus.addListener(this::registerNetworking);
    }

    private void registerNetworking(RegisterPayloadHandlerEvent event) {
        IPayloadRegistrar registrar = event.registrar(MOD_ID).optional();
        registrar.play(PartialBlockPacket.ID, PartialBlockPacket::new, handler -> handler.client(MultiMine.instance()::onPartialBlockForClient).server(MultiMine.instance()::onPartialBlock));
        registrar.play(PartialBlockRemovalPacket.ID, PartialBlockRemovalPacket::new, handler -> handler.client(MultiMine.instance()::onPartialBlockRemovalForClient));
    }

    private void onPartialBlockForClient(PartialBlockPacket packet, PlayPayloadContext playPayloadContext) {
        playPayloadContext.workHandler().submitAsync(() -> MultiMineClient.instance().onServerSentPartialBlockData(packet.x(), packet.y(), packet.z(), packet.value(), packet.regenerating()));
    }

    private void onPartialBlock(PartialBlockPacket packet, PlayPayloadContext playPayloadContext) {
        ServerPlayer p = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayerByName(packet.user());
        if (p != null) {
            playPayloadContext.workHandler().submitAsync(() -> MultiMineServer.instance().onClientSentPartialBlockPacket(p, packet.x(), packet.y(), packet.z(), packet.value()));
        }
    }

    private void onPartialBlockRemovalForClient(PartialBlockRemovalPacket packet, PlayPayloadContext playPayloadContext) {
        playPayloadContext.workHandler().submitAsync(() -> MultiMineClient.instance().onServerSentPartialBlockDeleteCommand(new BlockPos(packet.x(), packet.y(), packet.z())));
    }

    public void initIfNeeded(Level world) {
        if (this.configFile == null) {
            File mcFolder;
            if (world.isClientSide()) {
                mcFolder = MultiMineClient.getMcFolder();
            } else {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                mcFolder = server.getFile("");
            }
            this.configFile = new File(mcFolder, File.separatorChar + "config" + File.separatorChar + "multimine.cfg");
            this.loadConfig();
        }
    }

    private void loadConfig() {
        MultiMineConfig defaultConfig = new MultiMineConfig();
        defaultConfig.setDisableForAllTileEntities(false);
        LOGGER.info("config loading now");
        this.config = GsonConfig.loadConfigWithDefault(MultiMineConfig.class, this.configFile, defaultConfig);
        LOGGER.info("config loaded successfully");
    }

    public static MultiMine instance() {
        return instance;
    }

    public boolean getBlockRegenEnabled() {
        return this.config.isBlockRegenerationEnabled();
    }

    public long getInitialBlockRegenDelay() {
        return this.config.getInitialBlockRegenDelayMillis();
    }

    public long getBlockRegenInterval() {
        return this.config.getBlockRegenIntervalMillis();
    }

    public MultiMineConfig getConfig() {
        return this.config;
    }

    public void saveConfig() {
        GsonConfig.saveConfig(this.config, this.configFile);
    }

    public void debugPrint(String s, Object ... params) {
        if (this.config.isDebugMode()) {
            LOGGER.info(s, params);
        }
    }
}

