/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.multimine.common;

import atomicstryker.multimine.common.MultiMine;
import atomicstryker.multimine.common.PartiallyMinedBlock;
import atomicstryker.multimine.common.network.PartialBlockPacket;
import atomicstryker.multimine.common.network.PartialBlockRemovalPacket;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class MultiMineServer {
    private static MultiMineServer instance;
    private static MinecraftServer serverInstance;
    private final HashMap<ResourceKey<Level>, List<PartiallyMinedBlock>> partiallyMinedBlocksListByDimension;
    private final HashMap<ResourceKey<Level>, BlockRegenQueue> blockRegenQueuesByDimension;

    public MultiMineServer() {
        MultiMine.LOGGER.info("MultiMineServer initializing");
        instance = this;
        this.partiallyMinedBlocksListByDimension = Maps.newHashMap();
        this.blockRegenQueuesByDimension = Maps.newHashMap();
    }

    public static MultiMineServer instance() {
        return instance;
    }

    public void onClientSentPartialBlockPacket(ServerPlayer player, int x, int y, int z, float value) {
        serverInstance = ServerLifecycleHooks.getCurrentServer();
        ResourceKey dimension = player.level().dimension();
        MultiMine.instance().debugPrint("multi mine client {} sent progress packet: {}", player.getName().getContents(), Float.valueOf(value));
        BlockPos pos = new BlockPos(x, y, z);
        BlockState iblockstate = player.level().getBlockState(pos);
        if (this.isUsingBannedItem((Player)player) || this.isBlockBanned(iblockstate) || this.isItemTagBanned(player.getMainHandItem()) || this.isBlockTagBanned(iblockstate)) {
            this.sendPartiallyMinedBlockToPlayer(player, new PartiallyMinedBlock(x, y, z, (ResourceKey<Level>)dimension, -1.0f));
            return;
        }
        ArrayList partiallyMinedBlocks = this.getPartiallyMinedBlocksForDimension((ResourceKey<Level>)dimension);
        if (partiallyMinedBlocks == null) {
            partiallyMinedBlocks = Lists.newArrayList();
            this.partiallyMinedBlocksListByDimension.put((ResourceKey<Level>)dimension, partiallyMinedBlocks);
        }
        PartiallyMinedBlock newblock = new PartiallyMinedBlock(x, y, z, (ResourceKey<Level>)dimension, 0.0f);
        newblock.setLastTimeMined(System.currentTimeMillis() + MultiMine.instance().getInitialBlockRegenDelay());
        for (PartiallyMinedBlock iterBlock : partiallyMinedBlocks) {
            if (!iterBlock.equals(newblock)) continue;
            iterBlock.setProgress(Math.max(iterBlock.getProgress(), value));
            iterBlock.setLastTimeMined(System.currentTimeMillis() + MultiMine.instance().getInitialBlockRegenDelay());
            MultiMine.instance().debugPrint("Server updating partial block at: [{}|{}|{}], progress now: {}", x, y, z, Float.valueOf(iterBlock.getProgress()));
            this.sendPartiallyMinedBlockUpdateToAllPlayers(iterBlock, false);
            if (iterBlock.isFinished() && !player.level().getBlockState(pos).isAir()) {
                MultiMine.instance().debugPrint("Server popping, then forgetting block at: [{}|{}|{}]", x, y, z);
                player.gameMode.destroyBlock(pos);
                partiallyMinedBlocks.remove(iterBlock);
                this.getBlockRegenQueueForDimension((ResourceKey<Level>)dimension).remove(iterBlock);
            } else {
                this.getBlockRegenQueueForDimension((ResourceKey<Level>)dimension).offer(iterBlock);
            }
            return;
        }
        if (partiallyMinedBlocks.size() > 29) {
            PartiallyMinedBlock old = (PartiallyMinedBlock)partiallyMinedBlocks.get(0);
            this.sendPartiallyMinedBlockDeleteCommandToAllPlayers(old);
            partiallyMinedBlocks.remove(old);
            this.getBlockRegenQueueForDimension((ResourceKey<Level>)dimension).remove(old);
        }
        partiallyMinedBlocks.add(newblock);
        this.getBlockRegenQueueForDimension((ResourceKey<Level>)dimension).offer(newblock);
        this.sendPartiallyMinedBlockUpdateToAllPlayers(newblock, false);
    }

    private boolean isBlockBanned(BlockState blockState) {
        String blockIdentifier = BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock()).toString();
        Boolean result = MultiMine.instance().getConfig().getBannedBlocks().get(blockIdentifier);
        if (result != null) {
            return result;
        }
        result = false;
        if (!MultiMine.instance().getConfig().isDisableAutoRegisterNames()) {
            MultiMine.instance().getConfig().getBannedBlocks().put(blockIdentifier, result);
            MultiMine.instance().saveConfig();
        }
        return result;
    }

    private boolean isBlockTagBanned(BlockState blockState) {
        return blockState.getTags().anyMatch(blockTagKey -> {
            Boolean boolForTag = MultiMine.instance().getConfig().getBannedBlocks().get(blockTagKey.location().toString());
            return Objects.requireNonNullElse(boolForTag, false);
        });
    }

    private boolean isUsingBannedItem(Player player) {
        ItemStack item = player.getMainHandItem();
        String ident = BuiltInRegistries.ITEM.getKey((Object)item.getItem()).toString();
        Boolean result = MultiMine.instance().getConfig().getBannedItems().get(ident);
        if (result != null) {
            return result;
        }
        result = false;
        if (!MultiMine.instance().getConfig().isDisableAutoRegisterNames()) {
            MultiMine.instance().getConfig().getBannedItems().put(ident, result);
            MultiMine.instance().saveConfig();
        }
        return result;
    }

    private boolean isItemTagBanned(ItemStack handItem) {
        return handItem.getTags().anyMatch(itemTagKey -> {
            Boolean boolForTag = MultiMine.instance().getConfig().getBannedItems().get(itemTagKey.location().toString());
            return Objects.requireNonNullElse(boolForTag, false);
        });
    }

    private void sendPartiallyMinedBlockDeleteCommandToAllPlayers(PartiallyMinedBlock block) {
        PartialBlockRemovalPacket packet = new PartialBlockRemovalPacket(block.getPos().getX(), block.getPos().getY(), block.getPos().getZ());
        PacketDistributor.NEAR.with((Object)new PacketDistributor.TargetPoint((double)block.getPos().getX(), (double)block.getPos().getY(), (double)block.getPos().getZ(), 32.0, block.getDimension())).send(new CustomPacketPayload[]{packet});
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        ResourceKey dimensionKey = player.level().dimension();
        List<PartiallyMinedBlock> partiallyMinedBlocks = this.getPartiallyMinedBlocksForDimension((ResourceKey<Level>)dimensionKey);
        if (partiallyMinedBlocks != null) {
            for (PartiallyMinedBlock block : partiallyMinedBlocks) {
                this.sendPartiallyMinedBlockToPlayer((ServerPlayer)player, block);
            }
        }
    }

    private List<PartiallyMinedBlock> getPartiallyMinedBlocksForDimension(ResourceKey<Level> dim) {
        return this.partiallyMinedBlocksListByDimension.get(dim);
    }

    private void sendPartiallyMinedBlockUpdateToAllPlayers(PartiallyMinedBlock block, boolean regenerating) {
        PartialBlockPacket packet = new PartialBlockPacket("server", block.getPos().getX(), block.getPos().getY(), block.getPos().getZ(), block.getProgress(), regenerating);
        PacketDistributor.NEAR.with((Object)new PacketDistributor.TargetPoint((double)block.getPos().getX(), (double)block.getPos().getY(), (double)block.getPos().getZ(), 32.0, block.getDimension())).send(new CustomPacketPayload[]{packet});
    }

    private void sendPartiallyMinedBlockToPlayer(ServerPlayer p, PartiallyMinedBlock block) {
        PartialBlockPacket packet = new PartialBlockPacket("server", block.getPos().getX(), block.getPos().getY(), block.getPos().getZ(), block.getProgress(), false);
        PacketDistributor.PLAYER.with((Object)p).send(new CustomPacketPayload[]{packet});
    }

    @SubscribeEvent
    public void commonSetup(ServerStartedEvent evt) {
        MultiMine.LOGGER.info("MultiMine ServerStartedEvent");
        MultiMine.instance().initIfNeeded((Level)evt.getServer().getAllLevels().iterator().next());
    }

    @SubscribeEvent
    public void onTick(TickEvent.LevelTickEvent tick) {
        PartiallyMinedBlock block;
        if (tick.side.isClient() || tick.phase != TickEvent.Phase.END) {
            return;
        }
        BlockRegenQueue queueForDimension = this.getBlockRegenQueueForDimension((ResourceKey<Level>)tick.level.dimension());
        if (queueForDimension.isEmpty()) {
            return;
        }
        Iterator iter = queueForDimension.iterator();
        while (iter.hasNext()) {
            block = (PartiallyMinedBlock)iter.next();
            if (!this.isBlockGone(block)) continue;
            this.sendPartiallyMinedBlockDeleteCommandToAllPlayers(block);
            this.getPartiallyMinedBlocksForDimension(block.getDimension()).remove(block);
            iter.remove();
        }
        if (queueForDimension.isEmpty() || !MultiMine.instance().getBlockRegenEnabled()) {
            return;
        }
        long curTime = System.currentTimeMillis();
        if (((PartiallyMinedBlock)queueForDimension.peek()).getLastTimeMined() + MultiMine.instance().getBlockRegenInterval() < curTime) {
            block = (PartiallyMinedBlock)queueForDimension.poll();
            block.setProgress(block.getProgress() - 0.1f);
            block.setLastTimeMined(curTime);
            if (block.getProgress() < 0.0f) {
                MultiMine.instance().debugPrint("Server sending partial delete command for [{}|{}|{}]", block.getPos().getX(), block.getPos().getY(), block.getPos().getZ());
                this.sendPartiallyMinedBlockDeleteCommandToAllPlayers(block);
                this.getPartiallyMinedBlocksForDimension(block.getDimension()).remove(block);
            } else {
                MultiMine.instance().debugPrint("Server sending partial regen update for [{}|{}|{}]", block.getPos().getX(), block.getPos().getY(), block.getPos().getZ());
                this.sendPartiallyMinedBlockUpdateToAllPlayers(block, true);
                queueForDimension.add(block);
            }
        }
    }

    private boolean isBlockGone(PartiallyMinedBlock block) {
        return serverInstance.getLevel(block.getDimension()).isEmptyBlock(block.getPos());
    }

    private BlockRegenQueue getBlockRegenQueueForDimension(ResourceKey<Level> dimension) {
        BlockRegenQueue queueForDimension = this.blockRegenQueuesByDimension.get(dimension);
        if (queueForDimension == null) {
            queueForDimension = new BlockRegenQueue(30, new BlockAgeComparator());
            this.blockRegenQueuesByDimension.put(dimension, queueForDimension);
        }
        return queueForDimension;
    }

    private static class BlockRegenQueue
    extends PriorityQueue<PartiallyMinedBlock> {
        private static final long serialVersionUID = 1L;

        BlockRegenQueue(int initialSize, Comparator<PartiallyMinedBlock> comparator) {
            super(initialSize, comparator);
        }

        @Override
        public boolean offer(PartiallyMinedBlock block) {
            if (this.contains(block)) {
                this.remove(block);
            }
            return super.offer(block);
        }
    }

    private static class BlockAgeComparator
    implements Comparator<PartiallyMinedBlock> {
        private BlockAgeComparator() {
        }

        @Override
        public int compare(PartiallyMinedBlock b1, PartiallyMinedBlock b2) {
            return Long.compare(b1.getLastTimeMined(), b2.getLastTimeMined());
        }
    }
}

