/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.nutritionalbalance.capabilities;

import com.dannyandson.nutritionalbalance.Config;
import com.dannyandson.nutritionalbalance.api.INutritionalBalancePlayer;
import com.dannyandson.nutritionalbalance.api.IPlayerNutrient;
import com.dannyandson.nutritionalbalance.capabilities.DefaultPlayerNutrient;
import com.dannyandson.nutritionalbalance.nutrients.Nutrient;
import com.dannyandson.nutritionalbalance.nutrients.WorldNutrients;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class DefaultNutritionalBalancePlayer
implements INutritionalBalancePlayer {
    private final List<IPlayerNutrient> playerNutrients = new ArrayList<IPlayerNutrient>();
    private float savedSaturation;
    private IPlayerNutrient.NutrientStatus cachedStatus = IPlayerNutrient.NutrientStatus.SAFE;

    DefaultNutritionalBalancePlayer() {
        for (Nutrient nutrient : WorldNutrients.get()) {
            this.playerNutrients.add(new DefaultPlayerNutrient(nutrient));
        }
    }

    @Override
    public List<IPlayerNutrient> getPlayerNutrients() {
        return this.playerNutrients;
    }

    @Override
    public IPlayerNutrient getPlayerNutrientByName(String name) {
        for (IPlayerNutrient iPlayerNutrient : this.playerNutrients) {
            if (!iPlayerNutrient.getNutrient().name.equals(name)) continue;
            return iPlayerNutrient;
        }
        return null;
    }

    @Override
    public void processSaturationChange(float currentSaturation) {
        if (currentSaturation == this.savedSaturation) {
            return;
        }
        if (currentSaturation < this.savedSaturation) {
            float decrementer = ((Double)Config.NUTRIENT_DECAY_RATE.get()).floatValue() * (currentSaturation - this.savedSaturation) / (float)this.playerNutrients.size();
            for (IPlayerNutrient playernutrient : this.playerNutrients) {
                playernutrient.changeValue(decrementer);
            }
        }
        this.resetSavedSaturation(currentSaturation);
    }

    @Override
    public void resetSavedSaturation(float savedSaturation) {
        this.savedSaturation = savedSaturation;
    }

    @Override
    public void consume(ItemStack itemStack, World world) {
        Item item = itemStack.func_77973_b();
        Food food = item.func_219967_s();
        if (food != null) {
            List<Nutrient> nutrients = WorldNutrients.getNutrients(item, world);
            for (Nutrient nutrient : nutrients) {
                float nutrientUnits = WorldNutrients.getEffectiveFoodQuality(food) * ((Double)Config.NUTRIENT_INCREMENT_RATE.get()).floatValue() / (float)nutrients.size();
                this.getPlayerNutrientByName(nutrient.name).changeValue(nutrientUnits);
            }
        }
    }

    @Override
    public void consume(List<IPlayerNutrient> nutrients, float health, float saturation) {
        for (IPlayerNutrient nutrient : nutrients) {
            float nutrientUnits = WorldNutrients.getEffectiveFoodQuality(health, saturation) * ((Double)Config.NUTRIENT_INCREMENT_RATE.get()).floatValue() / (float)nutrients.size();
            this.getPlayerNutrientByName(nutrient.getNutrientName()).changeValue(nutrientUnits);
        }
    }

    @Override
    public IPlayerNutrient.NutrientStatus getStatus() {
        boolean safeFound = false;
        for (IPlayerNutrient playernutrient : this.playerNutrients) {
            IPlayerNutrient.NutrientStatus nutrientStatus = playernutrient.getStatus();
            if (nutrientStatus == IPlayerNutrient.NutrientStatus.MALNOURISHED) {
                this.cachedStatus = IPlayerNutrient.NutrientStatus.MALNOURISHED;
                return IPlayerNutrient.NutrientStatus.MALNOURISHED;
            }
            if (nutrientStatus == IPlayerNutrient.NutrientStatus.ENGORGED) {
                this.cachedStatus = IPlayerNutrient.NutrientStatus.ENGORGED;
                return IPlayerNutrient.NutrientStatus.ENGORGED;
            }
            if (nutrientStatus != IPlayerNutrient.NutrientStatus.SAFE) continue;
            safeFound = true;
        }
        if (!safeFound) {
            this.cachedStatus = IPlayerNutrient.NutrientStatus.ON_TARGET;
            return IPlayerNutrient.NutrientStatus.ON_TARGET;
        }
        this.cachedStatus = IPlayerNutrient.NutrientStatus.SAFE;
        return IPlayerNutrient.NutrientStatus.SAFE;
    }

    @Override
    public IPlayerNutrient.NutrientStatus getCachedStatus() {
        return this.cachedStatus;
    }
}

