/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.nutritionalbalance.capabilities;

import com.dannyandson.nutritionalbalance.Config;
import com.dannyandson.nutritionalbalance.api.IPlayerNutrient;
import com.dannyandson.nutritionalbalance.nutrients.Nutrient;
import com.dannyandson.nutritionalbalance.nutrients.WorldNutrients;
import java.util.List;
import net.minecraft.client.resources.I18n;

public class DefaultPlayerNutrient
implements IPlayerNutrient {
    private final String nutrientname;
    private float value;

    public DefaultPlayerNutrient(Nutrient nutrient) {
        this.nutrientname = nutrient.name;
        this.value = ((Double)Config.NUTRIENT_INITIAL.get()).floatValue();
    }

    @Override
    public Nutrient getNutrient() {
        return WorldNutrients.getByName(this.nutrientname);
    }

    @Override
    public String getNutrientName() {
        return this.nutrientname;
    }

    public String getLocalizedName() {
        return I18n.func_135052_a((String)("nutritionalbalance.nutrient." + this.nutrientname), (Object[])new Object[0]);
    }

    @Override
    public float getValue() {
        return this.value;
    }

    @Override
    public void changeValue(float i) {
        this.value += i;
        if (this.value > ((Double)Config.NUTRIENT_MAX.get()).floatValue()) {
            this.value = ((Double)Config.NUTRIENT_MAX.get()).floatValue();
        } else if (this.value < 0.0f) {
            this.value = 0.0f;
        }
    }

    @Override
    public void setValue(float value) {
        this.value = value;
    }

    @Override
    public IPlayerNutrient.NutrientStatus getStatus() {
        boolean badNutrient = false;
        for (String badNutrientName : (List)Config.BAD_NUTRIENTS.get()) {
            if (!badNutrientName.equals(this.nutrientname)) continue;
            badNutrient = true;
        }
        boolean goodNutrient = false;
        for (String goodNutrientName : (List)Config.GOOD_NUTRIENTS.get()) {
            if (!goodNutrientName.equals(this.nutrientname)) continue;
            goodNutrient = true;
        }
        if (this.value < ((Double)Config.NUTRIENT_MALNOURISHED.get()).floatValue() && !badNutrient) {
            return IPlayerNutrient.NutrientStatus.MALNOURISHED;
        }
        if (this.value > ((Double)Config.NUTRIENT_ENGORGED.get()).floatValue() && !goodNutrient) {
            return IPlayerNutrient.NutrientStatus.ENGORGED;
        }
        if (this.value > ((Double)Config.NUTRIENT_LOW_TARGET.get()).floatValue() && (double)this.value < (Double)Config.NUTRIENT_TARGET_HIGH.get() || goodNutrient && this.value > ((Double)Config.NUTRIENT_LOW_TARGET.get()).floatValue() || badNutrient && (double)this.value < (Double)Config.NUTRIENT_TARGET_HIGH.get()) {
            return IPlayerNutrient.NutrientStatus.ON_TARGET;
        }
        return IPlayerNutrient.NutrientStatus.SAFE;
    }
}

