/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.nutritionalbalance.commands;

import com.dannyandson.nutritionalbalance.api.IPlayerNutrient;
import com.dannyandson.nutritionalbalance.capabilities.CapabilityNutritionalBalancePlayer;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.StringJoiner;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class CommandGetNutrients
implements Command<CommandSource> {
    private static final CommandGetNutrients CMD = new CommandGetNutrients();

    public int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        String feedback = "Must be run on client.";
        ServerPlayerEntity player = (ServerPlayerEntity)((CommandSource)context.getSource()).func_197022_f();
        player.getCapability(CapabilityNutritionalBalancePlayer.HEALTHY_DIET_PLAYER_CAPABILITY).ifPresent(inutritionalbalancePlayer -> {
            StringJoiner stringJoiner = new StringJoiner("\n");
            stringJoiner.add("Player Nutrition:");
            for (IPlayerNutrient nutrient : inutritionalbalancePlayer.getPlayerNutrients()) {
                stringJoiner.add(nutrient.getNutrient().name + ": " + (float)Math.round(nutrient.getValue() * 10.0f) / 10.0f + " " + nutrient.getStatus().name());
            }
            stringJoiner.add("Overall Status: " + inutritionalbalancePlayer.getStatus().name());
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent(stringJoiner.toString()), false);
        });
        return 0;
    }

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"get_nutrients").requires(cs -> cs.func_197034_c(0))).executes((Command)CMD);
    }
}

