/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.nutritionalbalance.events;

import com.dannyandson.nutritionalbalance.NutritionalBalance;
import com.dannyandson.nutritionalbalance.nutrients.Nutrient;
import com.dannyandson.nutritionalbalance.nutrients.WorldNutrients;
import java.util.List;
import java.util.StringJoiner;
import net.minecraft.block.CakeBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventTooltip {
    @SubscribeEvent
    public void onItemToolTipEvent(ItemTooltipEvent event) {
        World world;
        ItemStack itemStack = event.getItemStack();
        Item item = itemStack.func_77973_b();
        if (event.getEntity() != null) {
            world = event.getEntity().field_70170_p;
        } else {
            try {
                world = Minecraft.func_71410_x().field_71441_e;
            }
            catch (Exception e) {
                NutritionalBalance.LOGGER.error("Exception during attempt to access tooltip by non-entity." + e.getLocalizedMessage());
                return;
            }
        }
        if (item.func_219967_s() != null || item instanceof BlockItem && ((BlockItem)item).func_179223_d() instanceof CakeBlock) {
            StringJoiner stringJoiner = new StringJoiner(", ");
            try {
                List<Nutrient> nutrients = WorldNutrients.getNutrients(item, world);
                for (Nutrient nutrient : nutrients) {
                    stringJoiner.add(nutrient.getLocalizedName());
                }
                if (stringJoiner.length() > 0) {
                    String NUvalue = "";
                    if (item.func_219967_s() != null) {
                        NUvalue = " (" + (float)Math.round(WorldNutrients.getEffectiveFoodQuality(item.func_219967_s()) * 10.0f) / 10.0f + "NU)";
                    }
                    event.getToolTip().add(ITextComponent.func_244388_a((String)("Nutrients: " + stringJoiner.toString() + NUvalue)));
                }
            }
            catch (Exception e) {
                NutritionalBalance.LOGGER.error("Exception thrown while adding nutrient info  for '" + item.func_190903_i().func_151000_E().getString() + "' to tooltips: " + e.getMessage());
            }
        }
    }
}

