/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.nutritionalbalance.gui;

import com.dannyandson.nutritionalbalance.Config;
import com.dannyandson.nutritionalbalance.api.INutritionalBalancePlayer;
import com.dannyandson.nutritionalbalance.api.IPlayerNutrient;
import com.dannyandson.nutritionalbalance.capabilities.CapabilityNutritionalBalancePlayer;
import com.dannyandson.nutritionalbalance.gui.ModWidget;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class NutrientGUI
extends Screen {
    private static final int WIDTH = 250;
    private static final int HEIGHT = 155;
    private INutritionalBalancePlayer inutritionalbalancePlayer;
    private ResourceLocation GUI = new ResourceLocation("nutritionalbalance", "textures/gui/nutrient_gui.png");

    public NutrientGUI() {
        super((ITextComponent)new TranslationTextComponent("nutritionalbalance.nutrients"));
    }

    protected void func_231160_c_() {
        int maxColumnWidth = 10;
        int columnHeight = 95;
        int colorColumnBackground = 0;
        int colorNutrientValueFill = -16763905;
        int colorTargetIndicator = -1727987968;
        int colorUnsafeIndicator = -1711341568;
        int relX = (this.field_230708_k_ - 250) / 2;
        int relY = (this.field_230709_l_ - 155) / 2;
        this.field_230706_i_.field_71439_g.getCapability(CapabilityNutritionalBalancePlayer.HEALTHY_DIET_PLAYER_CAPABILITY).ifPresent(inutritionalbalancePlayer -> {
            this.inutritionalbalancePlayer = inutritionalbalancePlayer;
        });
        this.func_230480_a_((Widget)new Button(relX + 85, relY + 130, 80, 20, (ITextComponent)new TranslationTextComponent("nutritionalbalance.close"), button -> this.close()));
        this.func_230480_a_(new ModWidget(relX, relY + 5, 250, 10, (ITextComponent)new TranslationTextComponent("nutritionalbalance.nutrients"), -16777216).setTextHAlignment(ModWidget.HAlignment.CENTER).setTextVAlignment(ModWidget.VAlignment.TOP));
        int nutrientcount = this.inutritionalbalancePlayer.getPlayerNutrients().size();
        if (nutrientcount > 0) {
            int nBlockWidth = 240 / nutrientcount;
            int columnWidth = Math.min(maxColumnWidth, nBlockWidth - 2);
            int columnBlockRelX = relX + 5 + nBlockWidth * (nutrientcount - 1);
            int columnDrawY = relY + 19;
            int engorged_bottom = Math.round((((Double)Config.NUTRIENT_MAX.get()).floatValue() - ((Double)Config.NUTRIENT_ENGORGED.get()).floatValue()) / ((Double)Config.NUTRIENT_MAX.get()).floatValue() * (float)columnHeight);
            int target_top = Math.round((((Double)Config.NUTRIENT_MAX.get()).floatValue() - ((Double)Config.NUTRIENT_TARGET_HIGH.get()).floatValue()) / ((Double)Config.NUTRIENT_MAX.get()).floatValue() * (float)columnHeight);
            int target_bottom = Math.round((((Double)Config.NUTRIENT_MAX.get()).floatValue() - ((Double)Config.NUTRIENT_LOW_TARGET.get()).floatValue()) / ((Double)Config.NUTRIENT_MAX.get()).floatValue() * (float)columnHeight);
            int malnourished_top = Math.round((((Double)Config.NUTRIENT_MAX.get()).floatValue() - ((Double)Config.NUTRIENT_MALNOURISHED.get()).floatValue()) / ((Double)Config.NUTRIENT_MAX.get()).floatValue() * (float)columnHeight);
            for (IPlayerNutrient playerNutrient : this.inutritionalbalancePlayer.getPlayerNutrients()) {
                int columnRelX = columnBlockRelX + (nBlockWidth - columnWidth) / 2;
                int nutrientValueHeight = Math.round(playerNutrient.getValue() / ((Double)Config.NUTRIENT_MAX.get()).floatValue() * (float)columnHeight);
                boolean nonEssentialNutrient = false;
                for (String badNutrientName : (List)Config.BAD_NUTRIENTS.get()) {
                    if (!badNutrientName.equals(playerNutrient.getNutrientName())) continue;
                    nonEssentialNutrient = true;
                }
                boolean goodNutrient = false;
                for (String goodNutrientName : (List)Config.GOOD_NUTRIENTS.get()) {
                    if (!goodNutrientName.equals(playerNutrient.getNutrientName())) continue;
                    goodNutrient = true;
                }
                this.func_230480_a_(new ModWidget(columnRelX - 1, columnDrawY - 1, columnWidth + 2, columnHeight + 2, -16777216));
                this.func_230480_a_(new ModWidget(columnRelX, columnDrawY, columnWidth, columnHeight, colorColumnBackground));
                this.func_230480_a_(new ModWidget(columnBlockRelX, columnDrawY + columnHeight + 2, nBlockWidth, 10, (ITextComponent)new TranslationTextComponent("nutritionalbalance.nutrient." + playerNutrient.getNutrientName()), -16777216).setTextHAlignment(ModWidget.HAlignment.CENTER));
                ((ModWidget)this.func_230480_a_(new ModWidget(columnRelX, columnDrawY + columnHeight - nutrientValueHeight, columnWidth, nutrientValueHeight, colorNutrientValueFill))).setToolTip(ITextComponent.func_244388_a((String)((float)Math.round(playerNutrient.getValue() * 10.0f) / 10.0f + "NU")));
                if (nonEssentialNutrient) {
                    ((ModWidget)this.func_230480_a_(new ModWidget(columnRelX, columnDrawY + columnHeight - 1, columnWidth, 1, colorTargetIndicator))).setToolTip(ITextComponent.func_244388_a((String)"Target: 0NU"));
                } else {
                    ((ModWidget)this.func_230480_a_(new ModWidget(columnRelX, columnDrawY + malnourished_top, columnWidth, 1, colorUnsafeIndicator))).setToolTip(ITextComponent.func_244388_a((String)("Malnourishment: " + ((Double)Config.NUTRIENT_MALNOURISHED.get()).toString() + "NU")));
                    ((ModWidget)this.func_230480_a_(new ModWidget(columnRelX, columnDrawY + target_bottom, columnWidth, 1, colorTargetIndicator))).setToolTip(ITextComponent.func_244388_a((String)("Target: " + ((Double)Config.NUTRIENT_LOW_TARGET.get()).toString() + "NU")));
                }
                if (goodNutrient) {
                    ((ModWidget)this.func_230480_a_(new ModWidget(columnRelX, columnDrawY, columnWidth, 1, colorTargetIndicator))).setToolTip(ITextComponent.func_244388_a((String)"Target Cap: \u221eNU"));
                } else {
                    ((ModWidget)this.func_230480_a_(new ModWidget(columnRelX, columnDrawY + engorged_bottom, columnWidth, 1, colorUnsafeIndicator))).setToolTip(ITextComponent.func_244388_a((String)("Engorgement: " + ((Double)Config.NUTRIENT_ENGORGED.get()).toString() + "NU")));
                    ((ModWidget)this.func_230480_a_(new ModWidget(columnRelX, columnDrawY + target_top, columnWidth, 1, colorTargetIndicator))).setToolTip(ITextComponent.func_244388_a((String)("Target Cap: " + ((Double)Config.NUTRIENT_TARGET_HIGH.get()).toString() + "NU")));
                }
                columnBlockRelX -= nBlockWidth;
            }
        }
    }

    public boolean func_231177_au__() {
        return false;
    }

    private void close() {
        this.field_230706_i_.func_147108_a(null);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.blendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(this.GUI);
        int relX = (this.field_230708_k_ - 250) / 2;
        int relY = (this.field_230709_l_ - 155) / 2;
        this.func_238474_b_(matrixStack, relX, relY, 0, 0, 250, 155);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public static void open() {
        Minecraft.func_71410_x().func_147108_a((Screen)new NutrientGUI());
    }
}

