/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.nutritionalbalance.network;

import com.dannyandson.nutritionalbalance.api.INutritionalBalancePlayer;
import com.dannyandson.nutritionalbalance.api.IPlayerNutrient;
import com.dannyandson.nutritionalbalance.capabilities.CapabilityNutritionalBalancePlayer;
import com.dannyandson.nutritionalbalance.capabilities.DefaultPlayerNutrient;
import com.dannyandson.nutritionalbalance.nutrients.Nutrient;
import com.dannyandson.nutritionalbalance.nutrients.WorldNutrients;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class PlayerSync {
    private final ResourceLocation id;
    private JsonObject inutritionalbalancePlayerJson = new JsonObject();

    public PlayerSync(ResourceLocation id, INutritionalBalancePlayer inutritionalbalancePlayer) {
        this.id = id;
        for (IPlayerNutrient iPlayerNutrient : inutritionalbalancePlayer.getPlayerNutrients()) {
            this.inutritionalbalancePlayerJson.addProperty(iPlayerNutrient.getNutrientName(), (Number)Float.valueOf(iPlayerNutrient.getValue()));
        }
    }

    public PlayerSync(PacketBuffer buffer) {
        this.id = buffer.func_192575_l();
        String bufferString = buffer.func_218666_n();
        this.inutritionalbalancePlayerJson = (JsonObject)new JsonParser().parse(bufferString);
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_192572_a(this.id);
        buf.func_180714_a(this.inutritionalbalancePlayerJson.toString());
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Minecraft.func_71410_x().field_71439_g.getCapability(CapabilityNutritionalBalancePlayer.HEALTHY_DIET_PLAYER_CAPABILITY).ifPresent(capabilitynutritionalbalancePlayer -> {
                for (Map.Entry jsonElementEntry : this.inutritionalbalancePlayerJson.entrySet()) {
                    IPlayerNutrient playerNutrient = capabilitynutritionalbalancePlayer.getPlayerNutrientByName((String)jsonElementEntry.getKey());
                    if (playerNutrient == null) {
                        Nutrient worldNutrient = WorldNutrients.getByName((String)jsonElementEntry.getKey());
                        playerNutrient = new DefaultPlayerNutrient(worldNutrient);
                        capabilitynutritionalbalancePlayer.getPlayerNutrients().add(playerNutrient);
                    }
                    playerNutrient.setValue(((JsonElement)jsonElementEntry.getValue()).getAsFloat());
                }
            });
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        return true;
    }
}

