/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.nutritionalbalance.nutrients;

import com.dannyandson.nutritionalbalance.Config;
import com.dannyandson.nutritionalbalance.nutrients.Nutrient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class WorldNutrients {
    private static final List<Nutrient> nutrients = new ArrayList<Nutrient>();
    private static final Map<Item, List<Nutrient>> nutrientMap = new HashMap<Item, List<Nutrient>>();

    public static void register() {
        WorldNutrients.reset();
        ITagCollection itemITagCollection = ItemTags.func_199903_a();
        Collection resourceLocationCollection = itemITagCollection.func_199908_a();
        for (ResourceLocation resourceLocation : resourceLocationCollection) {
            String namespace = resourceLocation.func_110624_b();
            String path = resourceLocation.func_110623_a();
            if (!namespace.equals("forge") || !path.startsWith("nutrients/")) continue;
            nutrients.add(new Nutrient(path.substring(10)));
        }
        if (nutrients.size() > 0 && WorldNutrients.getByName("proteins") == null) {
            nutrients.add(new Nutrient("proteins"));
        }
    }

    public static List<Nutrient> get() {
        if (nutrients.size() == 0) {
            WorldNutrients.register();
        }
        return nutrients;
    }

    public static Nutrient getByName(String name) {
        for (Nutrient nutrient : WorldNutrients.get()) {
            if (!nutrient.name.equals(name)) continue;
            return nutrient;
        }
        return null;
    }

    public static List<Nutrient> getNutrients(Item item, @Nullable World world) {
        return WorldNutrients.getNutrients(item, world, 1);
    }

    private static List<Nutrient> getNutrients(Item item, @Nullable World world, int iteration) {
        if (!nutrientMap.containsKey(item)) {
            Nutrient nutrient;
            ArrayList<Nutrient> nutrientList = new ArrayList<Nutrient>();
            Collection tags = ItemTags.func_199903_a().func_199913_a((Object)item);
            for (ResourceLocation tag : tags) {
                Nutrient nutrient2 = null;
                if (tag.func_110624_b().equals("forge") && tag.func_110623_a().startsWith("nutrients/")) {
                    nutrient2 = WorldNutrients.getByName(tag.func_110623_a().substring(10));
                } else if (((List)Config.LIST_Fruits.get()).contains("#" + tag.func_110624_b() + ":" + tag.func_110623_a()) && !nutrientList.contains(WorldNutrients.getByName("fruits"))) {
                    nutrient2 = WorldNutrients.getByName("fruits");
                } else if (((List)Config.LIST_PROTEINS.get()).contains("#" + tag.func_110624_b() + ":" + tag.func_110623_a()) && !nutrientList.contains(WorldNutrients.getByName("proteins"))) {
                    nutrient2 = WorldNutrients.getByName("proteins");
                } else if (((List)Config.LIST_CARBS.get()).contains("#" + tag.func_110624_b() + ":" + tag.func_110623_a()) && !nutrientList.contains(WorldNutrients.getByName("carbs"))) {
                    nutrient2 = WorldNutrients.getByName("carbs");
                } else if (((List)Config.LIST_VEGETABLES.get()).contains("#" + tag.func_110624_b() + ":" + tag.func_110623_a()) && !nutrientList.contains(WorldNutrients.getByName("vegetables"))) {
                    nutrient2 = WorldNutrients.getByName("vegetables");
                } else if (((List)Config.LIST_SUGARS.get()).contains("#" + tag.func_110624_b() + ":" + tag.func_110623_a()) && !nutrientList.contains(WorldNutrients.getByName("sugars"))) {
                    nutrient2 = WorldNutrients.getByName("sugars");
                }
                if (nutrient2 == null || nutrientList.contains(nutrient2)) continue;
                nutrientList.add(nutrient2);
            }
            String itemRegistryName = item.getRegistryName().func_110624_b() + ":" + item.getRegistryName().func_110623_a();
            if (((List)Config.LIST_Fruits.get()).contains(itemRegistryName) && !nutrientList.contains(WorldNutrients.getByName("fruits")) && (nutrient = WorldNutrients.getByName("fruits")) != null) {
                nutrientList.add(nutrient);
            }
            if (((List)Config.LIST_PROTEINS.get()).contains(itemRegistryName) && !nutrientList.contains(WorldNutrients.getByName("proteins")) && (nutrient = WorldNutrients.getByName("proteins")) != null) {
                nutrientList.add(nutrient);
            }
            if (((List)Config.LIST_CARBS.get()).contains(itemRegistryName) && !nutrientList.contains(WorldNutrients.getByName("carbs")) && (nutrient = WorldNutrients.getByName("carbs")) != null) {
                nutrientList.add(nutrient);
            }
            if (((List)Config.LIST_VEGETABLES.get()).contains(itemRegistryName) && !nutrientList.contains(WorldNutrients.getByName("vegetables")) && (nutrient = WorldNutrients.getByName("vegetables")) != null) {
                nutrientList.add(nutrient);
            }
            if (((List)Config.LIST_SUGARS.get()).contains(itemRegistryName) && !nutrientList.contains(WorldNutrients.getByName("sugars")) && (nutrient = WorldNutrients.getByName("sugars")) != null) {
                nutrientList.add(nutrient);
            }
            if (nutrientList.size() == 0 && iteration < 5) {
                if (item.func_219967_s() != null && item.func_219967_s().func_221467_c()) {
                    Nutrient proteinNutrient = WorldNutrients.getByName("proteins");
                    if (proteinNutrient != null && !nutrientList.contains(proteinNutrient)) {
                        nutrientList.add(proteinNutrient);
                    }
                } else if (world != null) {
                    Collection recipes = world.func_199532_z().func_199510_b();
                    for (IRecipe recipe : recipes) {
                        if (recipe.func_77571_b().func_77973_b() != item) continue;
                        NonNullList ingredients = recipe.func_192400_c();
                        for (Ingredient ingredient : ingredients) {
                            ItemStack[] itemStacks = ingredient.func_193365_a();
                            if (itemStacks.length <= 0) continue;
                            List<Nutrient> ingredientNutrients = WorldNutrients.getNutrients(itemStacks[0].func_77973_b(), world, iteration + 1);
                            for (Nutrient ingredientNutrient : ingredientNutrients) {
                                if (nutrientList.contains(ingredientNutrient)) continue;
                                nutrientList.add(ingredientNutrient);
                            }
                        }
                    }
                }
            }
            nutrientMap.put(item, nutrientList);
        }
        return nutrientMap.get(item);
    }

    public static float getEffectiveFoodQuality(Food foodItem) {
        return WorldNutrients.getEffectiveFoodQuality(foodItem.func_221466_a(), foodItem.func_221469_b());
    }

    public static float getEffectiveFoodQuality(float healing, float saturation) {
        float saturation1 = healing * saturation * 2.0f;
        return healing + saturation1;
    }

    public static void reset() {
        nutrients.clear();
        nutrientMap.clear();
    }
}

