/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.nutritionalbalance.commands;

import com.dannyandson.nutritionalbalance.api.INutritionalBalancePlayer;
import com.dannyandson.nutritionalbalance.api.IPlayerNutrient;
import com.dannyandson.nutritionalbalance.nutrients.PlayerNutritionData;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.StringJoiner;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class CommandGetNutrients
implements Command<CommandSourceStack> {
    private static final CommandGetNutrients CMD = new CommandGetNutrients();

    public int run(CommandContext<CommandSourceStack> context) {
        String feedback = "Must be run on client.";
        Entity entity = ((CommandSourceStack)context.getSource()).m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            INutritionalBalancePlayer iNutritionalBalancePlayer = PlayerNutritionData.getWorldNutritionData().getNutritionalBalancePlayer((Player)player);
            StringJoiner stringJoiner = new StringJoiner("\n");
            stringJoiner.add("Player Nutrition:");
            for (IPlayerNutrient nutrient : iNutritionalBalancePlayer.getPlayerNutrients()) {
                stringJoiner.add(nutrient.getNutrient().name + ": " + (float)Math.round(nutrient.getValue() * 10.0f) / 10.0f + " " + nutrient.getStatus().name());
            }
            stringJoiner.add("Overall Status: " + iNutritionalBalancePlayer.getStatus().name());
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TranslatableComponent(stringJoiner.toString()), false);
        }
        return 0;
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"get_nutrients").requires(cs -> cs.m_6761_(0))).executes((Command)CMD);
    }
}

