/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.nutritionalbalance.events;

import com.dannyandson.nutritionalbalance.api.INutritionalBalancePlayer;
import com.dannyandson.nutritionalbalance.api.IPlayerNutrient;
import com.dannyandson.nutritionalbalance.network.ModNetworkHandler;
import com.dannyandson.nutritionalbalance.network.PlayerSync;
import com.dannyandson.nutritionalbalance.nutrients.PlayerNutritionData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventPlayerTick {
    private int i = 0;

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Player playerEntity = event.player;
            INutritionalBalancePlayer iNutritionalBalancePlayer = PlayerNutritionData.getWorldNutritionData().getNutritionalBalancePlayer(playerEntity);
            float playerSaturation = playerEntity.m_36324_().m_38722_();
            int playerFoodLevel = playerEntity.m_36324_().m_38702_();
            float foodpoints = playerSaturation + (float)playerFoodLevel;
            iNutritionalBalancePlayer.processSaturationChange(foodpoints);
            if (this.i >= 200) {
                IPlayerNutrient.NutrientStatus cachedStatus = iNutritionalBalancePlayer.getCachedStatus();
                IPlayerNutrient.NutrientStatus currentStatus = iNutritionalBalancePlayer.getStatus();
                if (currentStatus == IPlayerNutrient.NutrientStatus.ENGORGED) {
                    playerEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 0, true, true));
                    playerEntity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 200, 0, true, true));
                } else if (currentStatus == IPlayerNutrient.NutrientStatus.MALNOURISHED) {
                    playerEntity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 200, 0, true, true));
                    playerEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, 0, true, true));
                } else if (currentStatus == IPlayerNutrient.NutrientStatus.ON_TARGET) {
                    playerEntity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 200, 0, true, true));
                    playerEntity.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 200, 0, true, true));
                    playerEntity.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 200, 0, true, true));
                }
                if (cachedStatus != currentStatus && !playerEntity.f_19853_.m_5776_()) {
                    PlayerSync playerSync = new PlayerSync(new ResourceLocation("nutritionalbalance", "playersync"), iNutritionalBalancePlayer);
                    ModNetworkHandler.sendToClient(playerSync, (ServerPlayer)playerEntity);
                }
                this.i = 0;
            }
            ++this.i;
        }
    }
}

