/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.nutritionalbalance.events;

import com.dannyandson.nutritionalbalance.NutritionalBalance;
import com.dannyandson.nutritionalbalance.nutrients.Nutrient;
import com.dannyandson.nutritionalbalance.nutrients.WorldNutrients;
import java.util.List;
import java.util.StringJoiner;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventTooltip {
    @SubscribeEvent
    public void onItemToolTipEvent(ItemTooltipEvent event) {
        Level world;
        ItemStack itemStack = event.getItemStack();
        Item item = itemStack.m_41720_();
        if (event.getEntity() != null) {
            world = event.getEntity().f_19853_;
        } else {
            try {
                world = Minecraft.m_91087_().f_91073_;
            }
            catch (Exception e) {
                NutritionalBalance.LOGGER.error("Exception during attempt to access tooltip by non-entity." + e.getLocalizedMessage());
                return;
            }
        }
        if (item.m_41473_() != null || item instanceof BlockItem && ((BlockItem)item).m_40614_() instanceof CakeBlock) {
            StringJoiner stringJoiner = new StringJoiner(", ");
            try {
                List<Nutrient> nutrients = WorldNutrients.getNutrients(item, world);
                for (Nutrient nutrient : nutrients) {
                    stringJoiner.add(nutrient.getLocalizedName());
                }
                if (stringJoiner.length() > 0) {
                    Object NUvalue = "";
                    if (item.m_41473_() != null) {
                        NUvalue = " (" + (float)Math.round(WorldNutrients.getEffectiveFoodQuality(item.m_41473_()) * 10.0f) / 10.0f + "NU)";
                    }
                    event.getToolTip().add(Component.m_130674_((String)("Nutrients: " + stringJoiner.toString() + (String)NUvalue)));
                }
            }
            catch (Exception e) {
                NutritionalBalance.LOGGER.error("Exception thrown while adding nutrient info  for '" + item.m_7968_().m_41611_().getString() + "' to tooltips: " + e.getMessage());
            }
        }
    }
}

