/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.nutritionalbalance.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class ModWidget
extends AbstractWidget {
    private HAlignment halignment = HAlignment.LEFT;
    private VAlignment valignment = VAlignment.TOP;
    private float scale = 1.0f;
    private int color;
    private int bgcolor = -1;
    private int textWidth;
    private int textHeight;
    private Component toolTipTextComponent;

    public ModWidget(int x, int y, int width, int height, Component title, int textColor, int bgColor) {
        super(x, y, width, height, title);
        this.color = textColor;
        this.bgcolor = bgColor;
        if (title.getString().length() > 0) {
            this.textWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.m_6035_());
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            this.textHeight = 9;
        }
    }

    public ModWidget(int x, int y, int width, int height, Component title, int textColor) {
        this(x, y, width, height, title, textColor, -1);
    }

    public ModWidget(int x, int y, int width, int height, Component title) {
        this(x, y, width, height, title, -1, -1);
    }

    public ModWidget(int x, int y, int width, int height, int bgColor) {
        this(x, y, width, height, Component.m_130674_((String)""), -1, bgColor);
    }

    public ModWidget setTextHAlignment(HAlignment alignment) {
        this.halignment = alignment;
        return this;
    }

    public ModWidget setTextVAlignment(VAlignment alignment) {
        this.valignment = alignment;
        return this;
    }

    public ModWidget setToolTip(Component textComponent) {
        this.toolTipTextComponent = textComponent;
        return this;
    }

    protected boolean m_93680_(double mouseX, double mouseY) {
        return false;
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTick) {
        if (this.f_93624_) {
            Font fr = Minecraft.m_91087_().f_91062_;
            int drawX = switch (this.halignment) {
                default -> this.f_93620_;
                case HAlignment.CENTER -> this.f_93620_ + (int)((float)((this.f_93618_ - this.textWidth) / 2) * this.scale);
                case HAlignment.RIGHT -> this.f_93620_ + (int)((float)(this.f_93618_ - this.textWidth) * this.scale);
            };
            switch (this.valignment) {
                default: {
                    int drawY = this.f_93621_;
                    break;
                }
                case MIDDLE: {
                    int drawY = this.f_93621_ + (int)((float)((this.f_93619_ - this.textHeight) / 2) * this.scale);
                    break;
                }
                case BOTTOM: {
                    int drawY = this.f_93621_ + (int)((float)(this.f_93619_ - this.textHeight) * this.scale);
                }
            }
            if (this.scale != 1.0f) {
                matrixStack.m_85836_();
                matrixStack.m_85841_(this.scale, this.scale, this.scale);
                matrixStack.m_85837_((double)drawX, (double)this.f_93621_, 0.0);
                fr.m_92877_(matrixStack, this.m_6035_().m_7532_(), (float)drawX, (float)this.f_93621_, this.color);
                matrixStack.m_85849_();
            } else {
                fr.m_92877_(matrixStack, this.m_6035_().m_7532_(), (float)drawX, (float)this.f_93621_, this.color);
            }
            if (this.bgcolor != -1) {
                ModWidget.m_93172_((PoseStack)matrixStack, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)this.bgcolor);
            }
            if (this.toolTipTextComponent != null && mouseX >= this.f_93620_ && mouseX <= this.f_93620_ + this.f_93618_ && mouseY >= this.f_93621_ && mouseY <= this.f_93621_ + this.f_93619_) {
                this.renderHoverToolTip(matrixStack, mouseX, mouseY);
            }
        }
    }

    public void renderHoverToolTip(PoseStack matrixStack, int mouseX, int mouseY) {
        if (this.toolTipTextComponent != null) {
            Font fr = Minecraft.m_91087_().f_91062_;
            int width = fr.m_92852_((FormattedText)this.toolTipTextComponent);
            Objects.requireNonNull(fr);
            int height = 9;
            ModWidget.m_93172_((PoseStack)matrixStack, (int)mouseX, (int)(mouseY + 10), (int)(mouseX + width + 4), (int)(mouseY + 10 + height + 4), (int)-872415232);
            ModWidget.m_93172_((PoseStack)matrixStack, (int)(mouseX + 1), (int)(mouseY + 11), (int)(mouseX + width + 3), (int)(mouseY + 10 + height + 3), (int)0x66EEEEEE);
            fr.m_92877_(matrixStack, this.toolTipTextComponent.m_7532_(), (float)((double)mouseX + 3.0), (float)((double)mouseY + 13.0), -65794);
        }
    }

    public void m_142291_(NarrationElementOutput p_169152_) {
    }

    public static enum HAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static enum VAlignment {
        TOP,
        MIDDLE,
        BOTTOM;

    }
}

