/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.nutritionalbalance.gui;

import com.dannyandson.nutritionalbalance.Config;
import com.dannyandson.nutritionalbalance.api.INutritionalBalancePlayer;
import com.dannyandson.nutritionalbalance.api.IPlayerNutrient;
import com.dannyandson.nutritionalbalance.gui.ModWidget;
import com.dannyandson.nutritionalbalance.nutrients.PlayerNutritionData;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class NutrientGUI
extends Screen {
    private static final int WIDTH = 250;
    private static final int HEIGHT = 155;
    private INutritionalBalancePlayer inutritionalbalancePlayer;
    private ResourceLocation GUI = new ResourceLocation("nutritionalbalance", "textures/gui/nutrient_gui.png");

    public NutrientGUI() {
        super((Component)new TranslatableComponent("nutritionalbalance.nutrients"));
    }

    protected void m_7856_() {
        int maxColumnWidth = 10;
        int columnHeight = 95;
        int colorColumnBackground = 0;
        int colorNutrientValueFill = -16763905;
        int colorTargetIndicator = -1727987968;
        int colorUnsafeIndicator = -1711341568;
        int relX = (this.f_96543_ - 250) / 2;
        int relY = (this.f_96544_ - 155) / 2;
        this.inutritionalbalancePlayer = PlayerNutritionData.getWorldNutritionData().getNutritionalBalancePlayer((Player)this.f_96541_.f_91074_);
        this.m_142416_((GuiEventListener)new Button(relX + 85, relY + 130, 80, 20, (Component)new TranslatableComponent("nutritionalbalance.close"), button -> this.close()));
        this.m_142416_((GuiEventListener)new ModWidget(relX, relY + 5, 250, 10, (Component)new TranslatableComponent("nutritionalbalance.nutrients"), -16777216).setTextHAlignment(ModWidget.HAlignment.CENTER).setTextVAlignment(ModWidget.VAlignment.TOP));
        int nutrientcount = this.inutritionalbalancePlayer.getPlayerNutrients().size();
        if (nutrientcount > 0) {
            int nBlockWidth = 240 / nutrientcount;
            int columnWidth = Math.min(maxColumnWidth, nBlockWidth - 2);
            int columnBlockRelX = relX + 5 + nBlockWidth * (nutrientcount - 1);
            int columnDrawY = relY + 19;
            int engorged_bottom = Math.round((((Double)Config.NUTRIENT_MAX.get()).floatValue() - ((Double)Config.NUTRIENT_ENGORGED.get()).floatValue()) / ((Double)Config.NUTRIENT_MAX.get()).floatValue() * (float)columnHeight);
            int target_top = Math.round((((Double)Config.NUTRIENT_MAX.get()).floatValue() - ((Double)Config.NUTRIENT_TARGET_HIGH.get()).floatValue()) / ((Double)Config.NUTRIENT_MAX.get()).floatValue() * (float)columnHeight);
            int target_bottom = Math.round((((Double)Config.NUTRIENT_MAX.get()).floatValue() - ((Double)Config.NUTRIENT_LOW_TARGET.get()).floatValue()) / ((Double)Config.NUTRIENT_MAX.get()).floatValue() * (float)columnHeight);
            int malnourished_top = Math.round((((Double)Config.NUTRIENT_MAX.get()).floatValue() - ((Double)Config.NUTRIENT_MALNOURISHED.get()).floatValue()) / ((Double)Config.NUTRIENT_MAX.get()).floatValue() * (float)columnHeight);
            for (IPlayerNutrient playerNutrient : this.inutritionalbalancePlayer.getPlayerNutrients()) {
                int columnRelX = columnBlockRelX + (nBlockWidth - columnWidth) / 2;
                int nutrientValueHeight = Math.round(playerNutrient.getValue() / ((Double)Config.NUTRIENT_MAX.get()).floatValue() * (float)columnHeight);
                boolean nonEssentialNutrient = false;
                for (String badNutrientName : (List)Config.BAD_NUTRIENTS.get()) {
                    if (!badNutrientName.equals(playerNutrient.getNutrientName())) continue;
                    nonEssentialNutrient = true;
                }
                boolean goodNutrient = false;
                for (String goodNutrientName : (List)Config.GOOD_NUTRIENTS.get()) {
                    if (!goodNutrientName.equals(playerNutrient.getNutrientName())) continue;
                    goodNutrient = true;
                }
                this.m_142416_((GuiEventListener)new ModWidget(columnRelX - 1, columnDrawY - 1, columnWidth + 2, columnHeight + 2, -16777216));
                this.m_142416_((GuiEventListener)new ModWidget(columnRelX, columnDrawY, columnWidth, columnHeight, colorColumnBackground));
                this.m_142416_((GuiEventListener)new ModWidget(columnBlockRelX, columnDrawY + columnHeight + 2, nBlockWidth, 10, (Component)new TranslatableComponent("nutritionalbalance.nutrient." + playerNutrient.getNutrientName()), -16777216).setTextHAlignment(ModWidget.HAlignment.CENTER));
                ((ModWidget)this.m_142416_((GuiEventListener)new ModWidget(columnRelX, columnDrawY + columnHeight - nutrientValueHeight, columnWidth, nutrientValueHeight, colorNutrientValueFill))).setToolTip(Component.m_130674_((String)((float)Math.round(playerNutrient.getValue() * 10.0f) / 10.0f + "NU")));
                if (nonEssentialNutrient) {
                    ((ModWidget)this.m_142416_((GuiEventListener)new ModWidget(columnRelX, columnDrawY + columnHeight - 1, columnWidth, 1, colorTargetIndicator))).setToolTip(Component.m_130674_((String)"Target: 0NU"));
                } else {
                    ((ModWidget)this.m_142416_((GuiEventListener)new ModWidget(columnRelX, columnDrawY + malnourished_top, columnWidth, 1, colorUnsafeIndicator))).setToolTip(Component.m_130674_((String)("Malnourishment: " + ((Double)Config.NUTRIENT_MALNOURISHED.get()).toString() + "NU")));
                    ((ModWidget)this.m_142416_((GuiEventListener)new ModWidget(columnRelX, columnDrawY + target_bottom, columnWidth, 1, colorTargetIndicator))).setToolTip(Component.m_130674_((String)("Target: " + ((Double)Config.NUTRIENT_LOW_TARGET.get()).toString() + "NU")));
                }
                if (goodNutrient) {
                    ((ModWidget)this.m_142416_((GuiEventListener)new ModWidget(columnRelX, columnDrawY, columnWidth, 1, colorTargetIndicator))).setToolTip(Component.m_130674_((String)"Target Cap: \u221eNU"));
                } else {
                    ((ModWidget)this.m_142416_((GuiEventListener)new ModWidget(columnRelX, columnDrawY + engorged_bottom, columnWidth, 1, colorUnsafeIndicator))).setToolTip(Component.m_130674_((String)("Engorgement: " + ((Double)Config.NUTRIENT_ENGORGED.get()).toString() + "NU")));
                    ((ModWidget)this.m_142416_((GuiEventListener)new ModWidget(columnRelX, columnDrawY + target_top, columnWidth, 1, colorTargetIndicator))).setToolTip(Component.m_130674_((String)("Target Cap: " + ((Double)Config.NUTRIENT_TARGET_HIGH.get()).toString() + "NU")));
                }
                columnBlockRelX -= nBlockWidth;
            }
        }
    }

    public boolean m_7043_() {
        return false;
    }

    private void close() {
        this.f_96541_.m_91152_(null);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.GUI);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.f_96541_.m_91097_().m_174784_(this.GUI);
        int relX = (this.f_96543_ - 250) / 2;
        int relY = (this.f_96544_ - 155) / 2;
        this.m_93228_(matrixStack, relX, relY, 0, 0, 250, 155);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public static void open() {
        Minecraft.m_91087_().m_91152_((Screen)new NutrientGUI());
    }
}

