/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.nutritionalbalance.network;

import com.dannyandson.nutritionalbalance.api.INutritionalBalancePlayer;
import com.dannyandson.nutritionalbalance.api.IPlayerNutrient;
import com.dannyandson.nutritionalbalance.capabilities.DefaultPlayerNutrient;
import com.dannyandson.nutritionalbalance.nutrients.Nutrient;
import com.dannyandson.nutritionalbalance.nutrients.PlayerNutritionData;
import com.dannyandson.nutritionalbalance.nutrients.WorldNutrients;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class PlayerSync {
    private final ResourceLocation id;
    private JsonObject inutritionalbalancePlayerJson = new JsonObject();

    public PlayerSync(ResourceLocation id, INutritionalBalancePlayer inutritionalbalancePlayer) {
        this.id = id;
        for (IPlayerNutrient iPlayerNutrient : inutritionalbalancePlayer.getPlayerNutrients()) {
            this.inutritionalbalancePlayerJson.addProperty(iPlayerNutrient.getNutrientName(), (Number)Float.valueOf(iPlayerNutrient.getValue()));
        }
    }

    public PlayerSync(FriendlyByteBuf buffer) {
        this.id = buffer.m_130281_();
        String bufferString = buffer.m_130277_();
        this.inutritionalbalancePlayerJson = (JsonObject)new JsonParser().parse(bufferString);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.id);
        buf.m_130070_(this.inutritionalbalancePlayerJson.toString());
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            INutritionalBalancePlayer iNutritionalBalancePlayer = PlayerNutritionData.getWorldNutritionData().getNutritionalBalancePlayer((Player)((NetworkEvent.Context)ctx.get()).getSender());
            for (Map.Entry jsonElementEntry : this.inutritionalbalancePlayerJson.entrySet()) {
                IPlayerNutrient playerNutrient = iNutritionalBalancePlayer.getPlayerNutrientByName((String)jsonElementEntry.getKey());
                if (playerNutrient == null) {
                    Nutrient worldNutrient = WorldNutrients.getByName((String)jsonElementEntry.getKey());
                    playerNutrient = new DefaultPlayerNutrient(worldNutrient);
                    iNutritionalBalancePlayer.getPlayerNutrients().add(playerNutrient);
                }
                playerNutrient.setValue(((JsonElement)jsonElementEntry.getValue()).getAsFloat());
            }
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        return true;
    }
}

