/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1041;
import net.minecraft.class_1535;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import subaraki.paintings.gui.PaintingButton;
import subaraki.paintings.mixins.ScreenAccessor;
import subaraki.paintings.mod.Paintings;
import subaraki.paintings.network.ServerNetwork;

public class PaintingScreen
extends class_437 {
    public static final int START_X = 10;
    public static final int START_Y = 30;
    public static final int GAP = 5;
    private final int entityID;
    private final class_4185 defaultButton = new class_4185(0, 0, 0, 0, (class_2561)new class_2585("default"), button -> {});
    private final class_1535[] types;
    private int scrollBarScroll = 0;

    public PaintingScreen(class_1535[] types, int entityID) {
        super((class_2561)new class_2588("select.a.painting"));
        this.types = types;
        this.entityID = entityID;
    }

    protected void method_25426() {
        super.method_25426();
        this.addButtons();
        this.scrollBarScroll = 0;
    }

    private void addButtons() {
        int END_X = this.field_22789 - 30;
        int prevHeight = this.types[0].method_6943();
        int posx = 10;
        int posy = 35;
        int index = 0;
        int rowstart = 0;
        for (class_1535 type : this.types) {
            if (posx + type.method_6945() > END_X || prevHeight > type.method_6943()) {
                this.centerRow(rowstart, index - 1);
                rowstart = index;
                posx = 10;
                posy += prevHeight + 5;
                prevHeight = type.method_6943();
            }
            this.method_37063((class_364)new PaintingButton(posx, posy, type.method_6945(), type.method_6943(), (class_2561)new class_2585(""), button -> {
                class_2540 buf = PacketByteBufs.create();
                buf.method_10814(class_2378.field_11150.method_10221((Object)type).toString());
                buf.writeInt(this.entityID);
                ClientPlayNetworking.send((class_2960)ServerNetwork.SERVER_PACKET, (class_2540)buf);
                this.method_25432();
                this.method_25419();
            }, type));
            posx += 5 + type.method_6945();
            ++index;
        }
        this.centerRow(rowstart, this.getRenderablesWithCast().size() - 1);
    }

    private void centerRow(int start, int end) {
        int left = this.getAbstractWidget((int)start).field_22760;
        int right = this.getAbstractWidget((int)end).field_22760 + this.getAbstractWidget(end).method_25368();
        int correction = (this.field_22789 - 20 - (right - left)) / 2;
        for (int i = start; i <= end; ++i) {
            class_339 widget = this.getAbstractWidget(i);
            if (!(widget instanceof PaintingButton)) continue;
            ((PaintingButton)widget).shiftX(correction);
        }
    }

    public void method_25394(class_4587 stack, int mouseX, int mouseY, float f) {
        this.method_25420(stack);
        PaintingScreen.method_25294((class_4587)stack, (int)10, (int)30, (int)(this.field_22789 - 10), (int)(this.field_22790 - 30), (int)0x44444444);
        class_1041 window = this.field_22787.method_22683();
        int scale = (int)window.method_4495();
        RenderSystem.enableScissor((int)(10 * scale), (int)(30 * scale), (int)(this.field_22789 * scale), (int)((this.field_22790 - 60) * scale));
        super.method_25394(stack, mouseX, mouseY, f);
        RenderSystem.disableScissor();
        if (!this.getRenderablesWithCast().isEmpty()) {
            this.drawFakeScrollBar(stack);
        }
        PaintingScreen.method_27534((class_4587)stack, (class_327)this.field_22793, (class_2561)this.field_22785, (int)(this.field_22789 / 2), (int)15, (int)0xFFFFFF);
        this.drawToolTips(stack, mouseX, mouseY);
    }

    public boolean method_25401(double mouseX, double mouseY, double mouseScroll) {
        class_339 last = this.getAbstractWidget(this.getRenderablesWithCast().size() - 1);
        class_339 first = this.getAbstractWidget(0);
        int foreseeBottomLimit = (int)((double)(last.field_22761 + last.method_25364()) + mouseScroll * 16.0);
        int bottomLimit = this.field_22790 - 30 - last.method_25364();
        int foreseeTopLimit = (int)((double)first.field_22761 + mouseScroll * 16.0);
        int topLimit = 35;
        if (mouseScroll < 0.0 && foreseeBottomLimit < bottomLimit) {
            return super.method_25401(mouseX, mouseY, mouseScroll);
        }
        if (mouseScroll > 0.0 && foreseeTopLimit > topLimit) {
            return super.method_25401(mouseX, mouseY, mouseScroll);
        }
        this.move(mouseScroll);
        return super.method_25401(mouseX, mouseY, mouseScroll);
    }

    public boolean method_25403(double mouseX, double mouseY, int buttonID, double amountX, double amountY) {
        amountY *= -1.0;
        class_339 last = this.getAbstractWidget(this.getRenderablesWithCast().size() - 1);
        class_339 first = this.getAbstractWidget(0);
        int foreseeBottomLimit = (int)((double)(last.field_22761 + last.method_25364()) + (amountY /= 2.0) * 16.0);
        int bottomLimit = this.field_22790 - 30 - last.method_25364();
        int foreseeTopLimit = (int)((double)first.field_22761 + amountY * 16.0);
        int topLimit = 35;
        if (amountY < 0.0 && foreseeBottomLimit < bottomLimit) {
            return super.method_25403(mouseX, mouseY, buttonID, amountX, amountY);
        }
        if (amountY > 0.0 && foreseeTopLimit > topLimit) {
            return super.method_25403(mouseX, mouseY, buttonID, amountX, amountY);
        }
        this.move(amountY);
        return super.method_25403(mouseX, mouseY, buttonID, amountX, amountY);
    }

    private void move(double scroll) {
        this.scrollBarScroll = (int)((double)this.scrollBarScroll - scroll * 16.0);
        for (class_4068 w : this.getRenderablesWithCast()) {
            this.getAbstractWidget((class_4068)w).field_22761 = (int)((double)this.getAbstractWidget((class_4068)w).field_22761 + scroll * 16.0);
        }
    }

    private void drawToolTips(class_4587 mat, int mouseX, int mouseY) {
        if (!Paintings.config.show_painting_size) {
            return;
        }
        for (class_4068 guiButton : this.getRenderablesWithCast()) {
            PaintingButton button;
            class_4068 class_40682 = guiButton;
            if (!(class_40682 instanceof PaintingButton) || !(button = (PaintingButton)class_40682).method_25405(mouseX, mouseY)) continue;
            class_2585 text = new class_2585(button.method_25368() / 16 + "x" + button.method_25364() / 16);
            class_2568 hover = new class_2568(class_2568.class_5247.field_24342, (Object)text);
            class_2583 style = class_2583.field_24360.method_10949(hover);
            this.method_25418(mat, style, this.field_22789 / 2 - this.field_22793.method_1727(text.method_10851()) - 4, this.field_22790 - 7);
        }
    }

    private void drawFakeScrollBar(class_4587 mat) {
        int top = this.getAbstractWidget((int)0).field_22761;
        float containerSize = this.field_22790 - 60;
        int bot = this.getAbstractWidget((int)(this.getRenderablesWithCast().size() - 1)).field_22761 + this.getAbstractWidget(this.getRenderablesWithCast().size() - 1).method_25364();
        float totalSize = bot - top + 5;
        float percent = containerSize / totalSize * 100.0f;
        if (percent < 100.0f) {
            float sizeBar = containerSize / 100.0f * percent;
            float relativeScroll = (float)this.scrollBarScroll / 100.0f * percent;
            this.method_25296(mat, this.field_22789 - 10, 30, this.field_22789, 30 + (int)containerSize, Integer.MIN_VALUE, -2145246686);
            this.method_25296(mat, this.field_22789 - 10, 30 + (int)relativeScroll, this.field_22789, 30 + (int)relativeScroll + (int)sizeBar, -2130706433, -2145246686);
        }
    }

    private class_339 getAbstractWidget(class_4068 widget) {
        class_4068 class_40682 = widget;
        if (class_40682 instanceof class_339) {
            class_339 abstractWidget = (class_339)class_40682;
            return abstractWidget;
        }
        return this.defaultButton;
    }

    private class_339 getAbstractWidget(int index) {
        if (index < 0 || index > this.getRenderablesWithCast().size()) {
            return this.defaultButton;
        }
        class_4068 w = this.getRenderablesWithCast().get(index);
        class_4068 class_40682 = w;
        if (class_40682 instanceof class_339) {
            class_339 abstractWidget = (class_339)class_40682;
            return abstractWidget;
        }
        return this.defaultButton;
    }

    public List<class_4068> getRenderablesWithCast() {
        return ((ScreenAccessor)((Object)this)).getRenderables();
    }
}

