/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import subaraki.paintings.Paintings;
import subaraki.paintings.utils.PaintingEntry;

public class PaintingPackReader {
    public static final ArrayList<PaintingEntry> addedPaintings = new ArrayList();

    public void init() {
        Paintings.LOGGER.info("loading json file and contents for paintings.");
        this.loadFromJson();
    }

    private void loadFromJson() {
        BufferedReader reader;
        Path dir;
        try {
            Paintings.LOGGER.info("Copying Over Base Template to /paintings");
            dir = Paths.get("./paintings", new String[0]);
            if (!Files.exists(dir, new LinkOption[0])) {
                Files.createDirectory(dir, new FileAttribute[0]);
                Files.copy(this.getClass().getResourceAsStream("/assets/paintings/paintings.json"), dir.resolve("paintings.json"), new CopyOption[0]);
            }
        }
        catch (IOException | NullPointerException e) {
            Paintings.LOGGER.warn("************************************");
            Paintings.LOGGER.warn("!*!*!*!*!");
            Paintings.LOGGER.error("Copying Base Template Failed");
            Paintings.LOGGER.error(e.getMessage());
            Paintings.LOGGER.warn("!*!*!*!*!");
            Paintings.LOGGER.warn("************************************");
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get("./resourcepacks", new String[0]));){
            Paintings.LOGGER.info("Reading out ResourcePacks to find painting related json files");
            for (Path resourcePackPath : directoryStream) {
                Paintings.LOGGER.info("Reading `{}`", (Object)resourcePackPath.getFileName().toString());
                try {
                    URI jarUri = new URI("jar:%s".formatted(resourcePackPath.toUri().getScheme()), resourcePackPath.toUri().getPath(), null);
                    try {
                        FileSystem system = this.initFileSystem(jarUri);
                        try {
                            Iterator resourcePacks = Files.walk(system.getPath("/", new String[0]), new FileVisitOption[0]).iterator();
                            while (resourcePacks.hasNext()) {
                                Path fileToCopy;
                                boolean copyOver = false;
                                Path next = (Path)resourcePacks.next();
                                if (Files.isRegularFile(next, new LinkOption[0]) && next.toString().endsWith("json")) {
                                    try {
                                        reader = new BufferedReader(new InputStreamReader(Files.newInputStream(next, new OpenOption[0])));
                                        try {
                                            Gson gson = new GsonBuilder().create();
                                            JsonElement je = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
                                            JsonObject json = je.getAsJsonObject();
                                            if (json.has("paintings")) {
                                                copyOver = true;
                                                Paintings.LOGGER.info("Validated: {}", (Object)next.getFileName().toString());
                                            }
                                        }
                                        finally {
                                            reader.close();
                                        }
                                    }
                                    catch (Exception e) {
                                        Paintings.LOGGER.warn("************************************");
                                        Paintings.LOGGER.error("`{}` Errored. Skipping.", (Object)next.getFileName().toString());
                                        Paintings.LOGGER.error(e.getMessage());
                                        Paintings.LOGGER.warn("************************************");
                                    }
                                }
                                if (!copyOver || !Files.notExists(fileToCopy = Path.of("./paintings", new String[0]).resolve(next.getFileName().toString()), new LinkOption[0])) continue;
                                Files.copy(next, fileToCopy, new CopyOption[0]);
                            }
                        }
                        finally {
                            if (system == null) continue;
                            system.close();
                        }
                    }
                    catch (Exception e) {
                        Paintings.LOGGER.warn("************************************");
                        Paintings.LOGGER.error("Invalid ResourcePack  {}", (Object)resourcePackPath.getFileName().toString());
                        Paintings.LOGGER.error(e.getMessage());
                        Paintings.LOGGER.warn("************************************");
                    }
                }
                catch (URISyntaxException e) {
                    Paintings.LOGGER.warn("************************************");
                    Paintings.LOGGER.error("Error Detected in ResourcePack `{}` ", (Object)resourcePackPath.getFileName().toString());
                    Paintings.LOGGER.warn((Object)e);
                    Paintings.LOGGER.warn("************************************");
                }
            }
        }
        catch (IOException e) {
            Paintings.LOGGER.warn("************************************");
            Paintings.LOGGER.warn("!*!*!*!*!");
            Paintings.LOGGER.error("A fatal error occurred reading the resource pack directory");
            Paintings.LOGGER.error("SKIPPING ENTIRE PROCESS");
            Paintings.LOGGER.warn("!*!*!*!*!");
            Paintings.LOGGER.warn("************************************");
            Paintings.LOGGER.warn((Object)e);
        }
        dir = Paths.get("./paintings", new String[0]);
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(dir);){
            Paintings.LOGGER.info("Started Reading all json files in /painting directory");
            for (Path filesInDirPath : ds) {
                Paintings.LOGGER.info((Object)filesInDirPath);
                Iterator jsonFiles = Files.walk(filesInDirPath, new FileVisitOption[0]).iterator();
                while (jsonFiles.hasNext()) {
                    Path nextJson = (Path)jsonFiles.next();
                    if (!Files.isRegularFile(nextJson, new LinkOption[0]) || !nextJson.toString().endsWith(".json")) continue;
                    InputStream stream = Files.newInputStream(nextJson, new OpenOption[0]);
                    Gson gson = new GsonBuilder().create();
                    reader = new BufferedReader(new InputStreamReader(stream));
                    JsonElement je = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
                    JsonObject json = je.getAsJsonObject();
                    JsonArray array = json.getAsJsonArray("paintings");
                    for (int index = 0; index < array.size(); ++index) {
                        JsonObject jsonObject = array.get(index).getAsJsonObject();
                        String textureName = jsonObject.get("name").getAsString();
                        int sizeX = 0;
                        int sizeY = 0;
                        if (jsonObject.has("x")) {
                            sizeX = jsonObject.get("x").getAsInt();
                        }
                        if (jsonObject.has("y")) {
                            sizeY = jsonObject.get("y").getAsInt();
                        }
                        if (jsonObject.has("square")) {
                            sizeX = sizeY = jsonObject.get("square").getAsInt();
                        }
                        if (sizeX == 0 || sizeY == 0) {
                            Paintings.LOGGER.error("Tried loading a painting where one of the sides was 0 ! ");
                            Paintings.LOGGER.error("Painting name is : " + textureName);
                            Paintings.LOGGER.error("Skipping...");
                            continue;
                        }
                        if (sizeX % 16 != 0 || sizeY % 16 != 0) {
                            Paintings.LOGGER.error("Tried loading a painting with a size that is not a multiple of 16 !! ");
                            Paintings.LOGGER.error("Painting name is : " + textureName);
                            Paintings.LOGGER.error("Skipping...");
                            continue;
                        }
                        PaintingEntry entry = new PaintingEntry(textureName, sizeX, sizeY);
                        Paintings.LOGGER.info(String.format("Loaded json painting %s , %d x %d", entry.getRefName(), entry.getSizeX(), entry.getSizeY()));
                        addedPaintings.add(entry);
                    }
                }
            }
        }
        catch (IOException e) {
            Paintings.LOGGER.warn("************************************");
            Paintings.LOGGER.warn("!*!*!*!*!");
            Paintings.LOGGER.warn("No Painting Packs Detected. You will not be able to use ");
            Paintings.LOGGER.warn("the Paintings ++ Mod correctly.");
            Paintings.LOGGER.warn("Make sure to select or set some in the resourcepack folder and/or ingame gui !");
            Paintings.LOGGER.warn("!*!*!*!*!");
            Paintings.LOGGER.warn("************************************");
            e.printStackTrace();
        }
    }

    private FileSystem initFileSystem(URI uri) throws IOException {
        try {
            return FileSystems.getFileSystem(uri);
        }
        catch (FileSystemNotFoundException e) {
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("create", "true");
            return FileSystems.newFileSystem(uri, env);
        }
    }
}

